/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.convert.AppConvert;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppTypeEnum;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformAppDO;
import com.elitescloud.cloudt.platform.model.params.app.AddAppParam;
import com.elitescloud.cloudt.platform.model.params.app.QueryAppParam;
import com.elitescloud.cloudt.platform.model.params.app.UpdateAppParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformAppVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAppService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepoProc;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepo;
import com.elitescloud.cloudt.system.service.callback.AppChangedCallback;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysPlatformAppServiceImpl
implements SysPlatformAppService {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformAppServiceImpl.class);
    private final SysPlatformAppRepo sysPlatformAppRepo;
    private final SysPlatformAppRepoProc sysPlatformAppRepoProc;
    private final RedisUtils redisUtils;
    private final SysPlatformMenusRepo sysPlatformMenusRepo;
    private final ObjectProvider<AppChangedCallback> appChangedCallbacks;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addApp(AddAppParam addAppParam) {
        List<SysPlatformAppDO> list = this.sysPlatformAppRepo.findByAppCode(addAppParam.getAppCode());
        if (!list.isEmpty()) {
            return ApiResult.fail((String)"AppCode\u91cd\u590d");
        }
        if (addAppParam.getAppState() == null) {
            addAppParam.setAppState(true);
        }
        SysPlatformAppDO saveDo = AppConvert.INSTANCE.saveParamToDo(addAppParam);
        Long id = ((SysPlatformAppDO)this.sysPlatformAppRepo.save(saveDo)).getId();
        this.clearCache();
        for (AppChangedCallback callback : this.appChangedCallbacks) {
            callback.onSave(true, saveDo.getAppCode());
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteFlagApp(Long id) {
        this.sysPlatformAppRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
            sysPlatformAppDO.setDeleteFlag(1);
            this.sysPlatformAppRepo.save(sysPlatformAppDO);
            this.clearCache();
            for (AppChangedCallback callback : this.appChangedCallbacks) {
                callback.onDelete(sysPlatformAppDO.getAppCode(), false);
            }
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteApp(Long id) {
        Optional appDo = this.sysPlatformAppRepo.findById(id);
        if (appDo.isPresent()) {
            log.info("App\u5e94\u7528\u5220\u9664\uff1a{}", appDo.get());
            this.sysPlatformAppRepo.deleteById(id);
            this.clearCache();
            for (AppChangedCallback callback : this.appChangedCallbacks) {
                callback.onDelete(((SysPlatformAppDO)appDo.get()).getAppCode(), true);
            }
        } else {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateApp(Long id, UpdateAppParam updateAppParam) {
        AtomicReference<Boolean> allowUpdate = new AtomicReference<Boolean>(false);
        this.sysPlatformAppRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
            sysPlatformAppDO.setAppName(updateAppParam.getAppName());
            sysPlatformAppDO.setAppType(updateAppParam.getAppType());
            sysPlatformAppDO.setAppDescribe(updateAppParam.getAppDescribe());
            sysPlatformAppDO.setAppOrder(updateAppParam.getAppOrder());
            this.sysPlatformAppRepo.save(sysPlatformAppDO);
            allowUpdate.set(true);
            this.clearCache();
            for (AppChangedCallback callback : this.appChangedCallbacks) {
                callback.onSave(false, sysPlatformAppDO.getAppCode());
            }
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        if (allowUpdate.get().booleanValue()) {
            return ApiResult.ok((Object)true);
        }
        return ApiResult.fail((String)"Code\u5df2\u7ecf\u5b58\u5728,\u91cd\u590d:");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateAppState(Long id, Boolean state) {
        this.sysPlatformAppRepo.findById(id).ifPresentOrElse(sysPlatformAppDO -> {
            sysPlatformAppDO.setAppState(state);
            this.sysPlatformAppRepo.save(sysPlatformAppDO);
            this.clearCache();
            for (AppChangedCallback callback : this.appChangedCallbacks) {
                callback.onEnabled(sysPlatformAppDO.getAppCode(), Boolean.TRUE.equals(state));
            }
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok();
    }

    @Override
    public ApiResult<SysPlatformAppVO> getApp(Long id) {
        Optional appDO = this.sysPlatformAppRepo.findById(id);
        if (appDO.isPresent()) {
            return ApiResult.ok((Object)AppConvert.INSTANCE.sysPlatformAppDOToSysPlatformAppVO((SysPlatformAppDO)appDO.get()));
        }
        return ApiResult.fail((String)"id\u4e0d\u5b58\u5728");
    }

    @Override
    public ApiResult<PagingVO<SysPlatformAppVO>> pageMng(QueryAppParam queryAppParam) {
        PagingVO pagingVo = this.sysPlatformAppRepoProc.pageMng(queryAppParam).map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO);
        return ApiResult.ok((Object)pagingVo);
    }

    @Override
    public ApiResult<List<SysUdcVO>> getAppType() {
        return ApiResult.ok(List.of(PlatformAppTypeEnum.APP_TYPE_SYS.getUdcVO(), PlatformAppTypeEnum.APP_TYPE_BUS.getUdcVO()));
    }

    @Override
    public ApiResult<List<CodeNameParam>> all() {
        List<CodeNameParam> result = this.sysPlatformAppRepoProc.allEnabled();
        try {
            this.redisUtils.set("cloudt_app", result.stream().map(t -> new com.elitescloud.cloudt.common.base.param.CodeNameParam(t.getCode(), t.getName())).collect(Collectors.toList()));
        }
        catch (Exception e) {
            log.error("\u7f13\u5b58APP\u5f02\u5e38", (Throwable)e);
        }
        return ApiResult.ok(result);
    }

    @Override
    public ApiResult<PagingVO<SysPlatformAppVO>> queryByPage(QueryAppParam queryAppParam) {
        PagingVO pagingVo = this.sysPlatformAppRepoProc.pageQuery(queryAppParam).map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO);
        return ApiResult.ok((Object)pagingVo);
    }

    private void clearCache() {
        try {
            this.redisUtils.del(new String[]{"cloudt_app"});
        }
        catch (Exception e) {
            log.error("\u6e05\u7a7aapp\u7f13\u5b58\u5f02\u5e38", (Throwable)e);
        }
    }

    public SysPlatformAppServiceImpl(SysPlatformAppRepo sysPlatformAppRepo, SysPlatformAppRepoProc sysPlatformAppRepoProc, RedisUtils redisUtils, SysPlatformMenusRepo sysPlatformMenusRepo, ObjectProvider<AppChangedCallback> appChangedCallbacks) {
        this.sysPlatformAppRepo = sysPlatformAppRepo;
        this.sysPlatformAppRepoProc = sysPlatformAppRepoProc;
        this.redisUtils = redisUtils;
        this.sysPlatformMenusRepo = sysPlatformMenusRepo;
        this.appChangedCallbacks = appChangedCallbacks;
    }
}

