/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.convert.UdcConvert;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformUdcDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformAppDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcValueDO;
import com.elitescloud.cloudt.platform.model.params.udc.AddUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.AddUdcValueParam;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.UdcValueSaveVO;
import com.elitescloud.cloudt.platform.model.params.udc.UpdateUdcParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueVO;
import com.elitescloud.cloudt.platform.service.SysPlatformUdcService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcValueRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcValueRepoProc;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanTemplate;
import com.querydsl.core.types.dsl.Expressions;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysPlatformUdcServiceImpl
extends BaseServiceImpl
implements SysPlatformUdcService {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformUdcServiceImpl.class);
    private final SysPlatformUdcRepo sysPlatformUdcRepo;
    private final SysPlatformUdcValueRepoProc sysPlatformUdcValueRepoProc;
    private final SysPlatformUdcValueRepo sysPlatformUdcValueRepo;
    private final SysPlatformAppRepo sysPlatformAppRepo;
    private final UdcProvider udcProvider;
    private final TaskExecutor taskExecutor;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addUdc(AddUdcParam addUdcParam) {
        List<SysPlatformAppDO> appList = this.sysPlatformAppRepo.findByAppCode(addUdcParam.getAppCode());
        if (appList.size() != 1) {
            return ApiResult.fail((String)(appList.isEmpty() ? "\u5e94\u7528\u7f16\u7801\u4e0d\u5b58\u5728" : "\u5e94\u7528\u7f16\u7801\u5f02\u5e38\uff0c\u5b58\u5728\u591a\u4e2a"));
        }
        int count = this.sysPlatformUdcRepo.countAllByAppCodeAndUdcCode(addUdcParam.getAppCode(), addUdcParam.getUdcCode());
        if (count != 0) {
            return ApiResult.fail((String)"\u5e94\u7528UDC\u7f16\u7801\u91cd\u590d");
        }
        SysPlatformUdcDO udcDo = UdcConvert.INSTANCE.saveParamToDo(addUdcParam);
        return ApiResult.ok((Object)((SysPlatformUdcDO)this.sysPlatformUdcRepo.save(udcDo)).getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addUdcValue(AddUdcValueParam addUdcValueParam) {
        SysPlatformUdcDO udcDo = this.sysPlatformUdcRepo.findAllByAppCodeAndUdcCode(addUdcValueParam.getAppCode(), addUdcValueParam.getUdcCode());
        if (udcDo == null) {
            return ApiResult.fail((String)("\u5e94\u7528APP\u7684UDC\u7f16\u7801\u4e0d\u5b58\u5728," + addUdcValueParam.getAppCode() + "," + addUdcValueParam.getUdcCode()));
        }
        int count = this.sysPlatformUdcValueRepo.countAllByAppCodeAndUdcCodeAndUdcValueCode(addUdcValueParam.getAppCode(), addUdcValueParam.getUdcCode(), addUdcValueParam.getUdcValueCode());
        if (count != 0) {
            return ApiResult.fail((String)"UDC\u7f16\u7801\u91cd\u590d");
        }
        SysPlatformUdcValueDO udcValueDo = UdcConvert.INSTANCE.saveParamToDo(addUdcValueParam);
        udcValueDo.setAllowDefault(true);
        udcValueDo = (SysPlatformUdcValueDO)this.sysPlatformUdcValueRepo.save(udcValueDo);
        this.clearCache(addUdcValueParam.getAppCode(), udcValueDo.getUdcCode());
        return ApiResult.ok((Object)udcValueDo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateUdcValue(UdcValueSaveVO saveVO) {
        Assert.notNull((Object)saveVO.getId(), (String)"ID\u4e3a\u7a7a");
        SysPlatformUdcValueDO udcValueDO = (SysPlatformUdcValueDO)this.sysPlatformUdcValueRepoProc.get(saveVO.getId());
        Assert.notNull((Object)udcValueDO, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        saveVO.setUdcOrder((Integer)ObjectUtil.defaultIfNull((Object)saveVO.getUdcOrder(), (Object)0));
        saveVO.setAllowStart((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getAllowStart(), (Object)true));
        UdcConvert.INSTANCE.copySaveVo2Do(saveVO, udcValueDO);
        this.sysPlatformUdcValueRepo.save(udcValueDO);
        return ApiResult.ok((Object)saveVO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteFlagUdc(Long id) {
        this.sysPlatformUdcRepo.findById(id).ifPresentOrElse(sysPlatformUdcDO -> {
            sysPlatformUdcDO.setDeleteFlag(1);
            this.sysPlatformUdcRepo.save(sysPlatformUdcDO);
            this.sysPlatformUdcValueRepo.findAllByAppCodeAndUdcCode(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode()).forEach(sysPlatformUdcValueDO -> {
                sysPlatformUdcValueDO.setDeleteFlag(1);
                this.sysPlatformUdcValueRepo.save(sysPlatformUdcValueDO);
            });
            this.clearCache(sysPlatformUdcDO.getAppCode(), null);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteFlagUdcValue(Long id) {
        this.sysPlatformUdcValueRepo.findById(id).ifPresentOrElse(sysPlatformUdcValueDO -> {
            sysPlatformUdcValueDO.setDeleteFlag(1);
            this.sysPlatformUdcValueRepo.save(sysPlatformUdcValueDO);
            this.clearCache(sysPlatformUdcValueDO.getAppCode(), sysPlatformUdcValueDO.getUdcCode());
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteUdc(Long id) {
        Optional udcDoOp = this.sysPlatformUdcRepo.findById(id);
        if (udcDoOp.isPresent()) {
            SysPlatformUdcDO udcDo = (SysPlatformUdcDO)udcDoOp.get();
            List<SysPlatformUdcValueDO> list = this.sysPlatformUdcValueRepo.findAllByAppCodeAndUdcCode(udcDo.getAppCode(), udcDo.getUdcCode());
            if (list.size() > 0) {
                return ApiResult.fail((String)"\u8bf7\u5148\u5220\u9664\u5168\u90e8UDC\u5b50\u9879");
            }
            this.sysPlatformUdcRepo.deleteById(id);
            this.clearCache(udcDo.getAppCode(), udcDo.getUdcCode());
        }
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteUdcValue(Long id) {
        SysPlatformUdcValueDO valueDO = (SysPlatformUdcValueDO)this.sysPlatformUdcValueRepoProc.get(id);
        if (valueDO == null) {
            return ApiResult.noData();
        }
        this.sysPlatformUdcValueRepo.deleteById(id);
        this.clearCache(valueDO.getAppCode(), valueDO.getUdcCode());
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateUdc(Long id, UpdateUdcParam updateUdcParam) {
        this.sysPlatformUdcRepo.findById(id).ifPresentOrElse(sysPlatformUdcDO -> {
            sysPlatformUdcDO.setUdcName(updateUdcParam.getUdcName());
            sysPlatformUdcDO.setAllowUpdate(updateUdcParam.getAllowUpdate());
            sysPlatformUdcDO.setAllowAddValue(updateUdcParam.getAllowAddValue());
            sysPlatformUdcDO.setUdcDescribe(updateUdcParam.getUdcDescribe());
            sysPlatformUdcDO.setParentUdcCode(updateUdcParam.getParentUdcCode());
            this.sysPlatformUdcRepo.save(sysPlatformUdcDO);
            this.clearCache(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode());
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateUdcValueAllowStart(Long id, Boolean allowStart) {
        this.sysPlatformUdcValueRepo.findById(id).ifPresentOrElse(sysPlatformUdcDO -> {
            sysPlatformUdcDO.setAllowStart(allowStart);
            this.sysPlatformUdcValueRepo.save(sysPlatformUdcDO);
            this.clearCache(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode());
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<SysPlatformUdcVO> getUdc(Long id) {
        AtomicReference atomicUdcVO = new AtomicReference();
        this.sysPlatformUdcRepo.findById(id).ifPresentOrElse(sysPlatformUdcDO -> {
            SysPlatformUdcVO sysPlatformUdcVO1 = UdcConvert.INSTANCE.selectDOToVO((SysPlatformUdcDO)sysPlatformUdcDO);
            List<SysPlatformUdcValueVO> udcValueVOList = this.sysPlatformUdcValueRepo.findAllByAppCodeAndUdcCode(sysPlatformUdcDO.getAppCode(), sysPlatformUdcDO.getUdcCode()).stream().map(UdcConvert.INSTANCE::selectDOToVO).sorted(this.comparatorOfUdcValue()).collect(Collectors.toList());
            sysPlatformUdcVO1.setSysPlatformUdcValueVOList(udcValueVOList);
            atomicUdcVO.set(sysPlatformUdcVO1);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)((SysPlatformUdcVO)atomicUdcVO.get()));
    }

    @Override
    public ApiResult<PagingVO<SysPlatformUdcVO>> queryUdc(QueryUdcParam queryUdcParam) {
        QSysPlatformUdcDO qdo = QSysPlatformUdcDO.sysPlatformUdcDO;
        BooleanTemplate predicate = Expressions.booleanTemplate((String)"1=1", (Object[])new Object[0]);
        predicate = StringUtils.isBlank((CharSequence)queryUdcParam.getAppCode()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)qdo.appCode.eq((Object)queryUdcParam.getAppCode()));
        predicate = StringUtils.isBlank((CharSequence)queryUdcParam.getUdcName()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)qdo.udcName.like("%" + queryUdcParam.getUdcName() + "%"));
        predicate = StringUtils.isBlank((CharSequence)queryUdcParam.getUdcCode()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)qdo.udcCode.eq((Object)queryUdcParam.getUdcCode()));
        Page page = this.sysPlatformUdcRepo.findAll((Predicate)predicate, (Pageable)queryUdcParam.getPageRequest());
        PagingVO pagingVo = PagingVO.builder().total(page.getTotalElements()).setRecords(page.get().map(UdcConvert.INSTANCE::selectDOToVO).collect(Collectors.toList()));
        return ApiResult.ok((Object)pagingVo);
    }

    @Override
    public ApiResult<List<CodeNameParam>> getValueList(String appCode, String udcCode) {
        Assert.hasText((String)appCode, (String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a");
        Assert.hasText((String)udcCode, (String)"UDC\u7f16\u7801\u4e3a\u7a7a");
        List<CodeNameParam> result = this.sysPlatformUdcValueRepoProc.getValueList(appCode, udcCode, true);
        return ApiResult.ok(result);
    }

    private void clearCache(String appCode, String udcCode) {
        this.udcProvider.clearCache(appCode, udcCode);
    }

    private <T> void applyForAllTenant(Supplier<T> supplier) {
        CompletableFuture.runAsync(() -> this.tenantDataIsolateProvider.byAllTenant(((Supplier)supplier)::get), (Executor)this.taskExecutor).whenComplete((res, e) -> {
            if (e != null) {
                log.error("\u6267\u884c\u5f02\u5e38\uff1a", e);
            }
        });
    }

    private Comparator<SysPlatformUdcValueVO> comparatorOfUdcValue() {
        return Comparator.comparing(SysPlatformUdcValueVO::getUdcOrder, Comparator.nullsFirst(Integer::compareTo)).reversed();
    }

    public SysPlatformUdcServiceImpl(SysPlatformUdcRepo sysPlatformUdcRepo, SysPlatformUdcValueRepoProc sysPlatformUdcValueRepoProc, SysPlatformUdcValueRepo sysPlatformUdcValueRepo, SysPlatformAppRepo sysPlatformAppRepo, UdcProvider udcProvider, TaskExecutor taskExecutor) {
        this.sysPlatformUdcRepo = sysPlatformUdcRepo;
        this.sysPlatformUdcValueRepoProc = sysPlatformUdcValueRepoProc;
        this.sysPlatformUdcValueRepo = sysPlatformUdcValueRepo;
        this.sysPlatformAppRepo = sysPlatformAppRepo;
        this.udcProvider = udcProvider;
        this.taskExecutor = taskExecutor;
    }
}

