/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.convert.AppConvert;
import com.elitescloud.cloudt.platform.convert.MenusConvert;
import com.elitescloud.cloudt.platform.model.constant.PlatformAdminTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformAdminMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.params.admin.AddAdminMenusParam;
import com.elitescloud.cloudt.platform.model.vo.GetAdminMenusVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformAppVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAdminMenusService;
import com.elitescloud.cloudt.platform.service.SysPlatformMenusService;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAdminMenusRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformAppRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformMenusRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class SysPlatformAdminMenusServiceImpl
implements SysPlatformAdminMenusService {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformAdminMenusServiceImpl.class);
    private final SysPlatformMenusService sysPlatformMenusService;
    private final SysPlatformAdminMenusRepo sysPlatformAdminMenusRepo;
    private final SysPlatformMenusRepo sysPlatformMenusRepo;
    private final SysPlatformAppRepo sysPlatformAppRepo;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> addAdminMenus(AddAdminMenusParam addAdminMenusParam) {
        if (addAdminMenusParam.getMenusCodeList() != null && addAdminMenusParam.getMenusCodeList().size() > 0) {
            addAdminMenusParam.getMenusCodeList().forEach(code -> {
                SysPlatformMenusDO sysPlatformMenusDO = this.sysPlatformMenusRepo.findByMenusCode((String)code);
                Assert.notNull((Object)((Object)sysPlatformMenusDO), (String)("\u83dc\u5355\u7f16\u7801\u4e0d\u5b58\u5728:" + code));
                if (!sysPlatformMenusDO.getNodeType().equals(PlatformMenusNodeEnum.MENUS.name())) {
                    throw new BusinessException("\u975e\u6cd5\u7f16\u7801,\u4e0d\u662f\u83dc\u5355\u7c7b\u578b:" + code);
                }
            });
        }
        List listDO = addAdminMenusParam.getMenusCodeList().stream().map(s -> {
            SysPlatformAdminMenusDO sysPlatformAdminMenusDO = new SysPlatformAdminMenusDO();
            sysPlatformAdminMenusDO.setMenusCode((String)s);
            sysPlatformAdminMenusDO.setAdminType(addAdminMenusParam.getAdminType().name());
            return sysPlatformAdminMenusDO;
        }).collect(Collectors.toList());
        this.sysPlatformAdminMenusRepo.deleteAllByAdminType(addAdminMenusParam.getAdminType().name());
        this.sysPlatformAdminMenusRepo.saveAll(listDO);
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<GetAdminMenusVO> getAdminMenus(PlatformAdminTypeEnum adminType) {
        List<SysPlatformAppVO> sysPlatformAppVOS = new ArrayList<SysPlatformAppVO>();
        ArrayList<SysPlatformMenusVO> sysPlatformMenusVOS = new ArrayList();
        List<SysPlatformAdminMenusDO> adminMenusDO = this.sysPlatformAdminMenusRepo.findAllByAdminType(adminType.name());
        List<String> menusCodeList = adminMenusDO.stream().map(SysPlatformAdminMenusDO::getMenusCode).collect(Collectors.toList());
        List<SysPlatformMenusDO> menusDOList = this.sysPlatformMenusRepo.findAllByMenusCodeIn(menusCodeList);
        sysPlatformMenusVOS = menusDOList.stream().map(MenusConvert.INSTANCE::sysPlatformDOToSysPlatformVO).filter(SysPlatformMenusVO::getMenusState).collect(Collectors.toList());
        List<String> appCodeList = menusDOList.stream().map(SysPlatformMenusDO::getMenusAppCode).collect(Collectors.toList());
        if (!appCodeList.isEmpty()) {
            sysPlatformAppVOS = this.sysPlatformAppRepo.findByAppCodeIn(appCodeList).stream().filter(t -> Boolean.TRUE.equals(t.getAppState())).map(AppConvert.INSTANCE::sysPlatformAppDOToSysPlatformAppVO).collect(Collectors.toList());
        }
        GetAdminMenusVO getAdminMenusVO = new GetAdminMenusVO();
        getAdminMenusVO.setAdminType(adminType.name());
        getAdminMenusVO.setAdminTypeName(adminType.getDescription());
        getAdminMenusVO.setSysPlatformAppVOS(sysPlatformAppVOS);
        getAdminMenusVO.setSysPlatformMenusVOS(sysPlatformMenusVOS);
        return ApiResult.ok((Object)getAdminMenusVO);
    }

    public SysPlatformAdminMenusServiceImpl(SysPlatformMenusService sysPlatformMenusService, SysPlatformAdminMenusRepo sysPlatformAdminMenusRepo, SysPlatformMenusRepo sysPlatformMenusRepo, SysPlatformAppRepo sysPlatformAppRepo) {
        this.sysPlatformMenusService = sysPlatformMenusService;
        this.sysPlatformAdminMenusRepo = sysPlatformAdminMenusRepo;
        this.sysPlatformMenusRepo = sysPlatformMenusRepo;
        this.sysPlatformAppRepo = sysPlatformAppRepo;
    }
}

