package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

@Entity
@Table(name = TableNameConstant.SYS_PLATFORM_API_MANAGE, indexes = {
        @Index(name = "idx_api_app", columnList = "appCode"),
        @Index(name = "idx_api_code", columnList = "apiCode", unique = true),
})
@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_PLATFORM_API_MANAGE, comment = "接口管理")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = TableNameConstant.SYS_PLATFORM_API_MANAGE, description = "接口管理")
public class SysPlatformApiManageDO extends BaseStdModel {
    private static final long serialVersionUID = -5661893871840985181L;

    @Comment("接口所属应用 app_name")
    @Column(nullable = false)
    private String appCode;

    @Comment("接口名称 operation_type_name")
    @Column(nullable = false)
    private String apiName;

    @Comment("接口编号 operation_type")
    @Column(nullable = false)
    private String apiCode;

    @Comment("请求类型")
    @Column
    private String requestType;

    @Comment("请求路径")
    @Column(nullable = false)
    private String apiPath;

    @Comment("接口描述 operation_description")
    @Column
    private String apiDescribe;



    @Comment("操作范围 OperationScopeEnum")
    @Column
    private String operationScope;
    @Comment("操作状态 operationStateEnum")
    @Column
    private String  operationState ;
    @Comment("业务对象编码 ")
    @Column
    private String business_type;
    @Comment("业务对象名称")
    @Column
    private String businessTypeName;
    @Comment("业务对象描述")
    @Column
    private String businessTypeDescription;


}
