package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.constant.PlatformAdminTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.platform.model.vo.GetAdminMenusVO;
import com.elitescloud.cloudt.platform.model.params.admin.AddAdminMenusParam;
import com.elitescloud.cloudt.platform.model.vo.GetAppMenusVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAdminMenusService;
import com.elitescloud.cloudt.platform.service.SysPlatformMenusService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Slf4j
@RestController
@Api(value = "平台管理员菜单权限", tags = {"平台管理员菜单权限"})
@RequestMapping("/sys/platform/adminMenus")
public class SysPlatformAdminMenusController {

    private final SysPlatformAdminMenusService sysPlatformAdminMenusService;
    private final SysPlatformMenusService sysPlatformMenusService;
    public SysPlatformAdminMenusController(SysPlatformAdminMenusService sysPlatformAdminMenusService,
                                           SysPlatformMenusService sysPlatformMenusService) {
        this.sysPlatformAdminMenusService = sysPlatformAdminMenusService;
        this.sysPlatformMenusService = sysPlatformMenusService;
    }

    /**
     * 添加管理员菜单 全删全插
     **/
    @PostMapping("/addAdminMenus")
    @ApiOperation(value = "添加管理员菜单", notes = "平台菜单管理")
    public ApiResult<Boolean> addAdminMenus(@RequestBody @Validated AddAdminMenusParam addAdminMenusParam) {
        return sysPlatformAdminMenusService.addAdminMenus(addAdminMenusParam);
    }

    /**
     * 返回应用和菜单数据
     **/
    @GetMapping("/getSysAppMenus")
    @ApiOperation(value = "返回系统应用和系统菜单数据-启用状态", notes = "平台菜单管理")
    public ApiResult<GetAppMenusVO> getSysAppMenus() {
        return sysPlatformMenusService.getSysBusAppMenus(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS);
    }

    /**
     * 查询管理员菜单
     **/
    @GetMapping("/getAdminMenu")
    @ApiOperation(value = "返回管理员菜单", notes = "平台菜单管理")
    public ApiResult<GetAdminMenusVO> getAdminMenus(@RequestParam PlatformAdminTypeEnum adminType) {
        return sysPlatformAdminMenusService.getAdminMenus(adminType);
    }

}
