//package com.elitescloud.cloudt.platform.controller.api;
//
//import com.elitescloud.boot.excel.common.ExportExcelService;
//import com.elitescloud.boot.log.common.BusinessObject;
//import com.elitescloud.boot.log.common.BusinessObjectOperation;
//import com.elitescloud.boot.log.common.OperationTypeEnum;
//import com.elitescloud.cloudt.common.base.ApiResult;
//import com.elitescloud.cloudt.common.base.PagingVO;
//import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcParam;
//import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcValueParam;
//import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcVO;
//import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueMngVO;
//import com.elitescloud.cloudt.platform.service.SysPlatformUdcMngService;
//import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectConstant;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.http.MediaType;
//import org.springframework.web.bind.annotation.PostMapping;
//import org.springframework.web.bind.annotation.RequestBody;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RestController;
//
//import javax.servlet.http.HttpServletResponse;
//import javax.validation.Valid;
//import java.io.Serializable;
//import java.util.HashMap;
//import java.util.List;
//
///**
// * @author lucan.liu
// * @date 2023-11-13 14:59
// */
//@Slf4j
//@RestController
//@Api(value = "平台udc", tags = {"平台udc"})
//@RequestMapping("/sys/platform/udc/mng")
//@BusinessObject(businessType = BusinessObjectConstant.SYS_PLATFORM_UDC)
//public class SysPlatformUdcMngController {
//    @Autowired
//    private SysPlatformUdcMngService sysPlatformUdcMngService;
//
//    private ExportExcelService<QueryUdcValueParam, SysPlatformUdcValueMngVO, Serializable> exportExcelService;
//
//    @PostMapping("/queryUdc")
//    @ApiOperation(value = "分页查询UDC", notes = "平台udc")
//    @BusinessObjectOperation(
//            operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "分页查询UDC"
//    )
//    public ApiResult<PagingVO<SysPlatformUdcVO>> queryUdc(@RequestBody @Valid QueryUdcParam queryUdcParam) {
//        PagingVO<SysPlatformUdcVO> page = sysPlatformUdcMngService.queryUdc(queryUdcParam);
//        return ApiResult.ok(page);
//    }
//
//    @PostMapping("/queryUdcValue")
//    @ApiOperation(value = "查询UDC值", notes = "平台udc")
//    @BusinessObjectOperation(
//            operationType = OperationTypeEnum.SELECT, operationDescription = "查询UDC值"
//    )
//    public ApiResult<List<SysPlatformUdcValueMngVO>> queryUdcValue(@RequestBody HashMap<String, Object> param) {
//        return ApiResult.ok(sysPlatformUdcMngService.queryUdcValue(param));
//    }
//
//    @PostMapping("/queryUdcValueList")
//    @ApiOperation(value = "分页查询UDC值列表", notes = "平台udc")
//    @BusinessObjectOperation(
//            operationType = OperationTypeEnum.SELECT_PAGE, operationDescription = "分页查询UDC值"
//    )
//    public ApiResult<PagingVO<SysPlatformUdcValueMngVO>> queryUdcValueList(@RequestBody @Valid QueryUdcValueParam param) {
//        PagingVO<SysPlatformUdcValueMngVO> page = sysPlatformUdcMngService.getUdcValuePage(param);
//        return ApiResult.ok(page);
//    }
//
//    @PostMapping(value = "/export", produces = MediaType.APPLICATION_OCTET_STREAM_VALUE)
//    @ApiOperation(value = "导出数据")
//    @BusinessObjectOperation(
//            operationType = OperationTypeEnum.EXPORT, operationDescription = "导出数据"
//    )
//    public ApiResult<Boolean> export(HttpServletResponse response, @RequestBody QueryUdcValueParam queryVO) {
//        try {
//            exportExcelService.export(queryVO, response, param -> sysPlatformUdcMngService.getUdcValuePage(param)).get();
//            return null;
//        } catch (Exception e) {
//            log.error("导出失败：", e);
//            return ApiResult.fail("导出失败：" + e.getMessage());
//        }
//    }
//
//    @Autowired
//    public void setExportExcelService(ExportExcelService<QueryUdcValueParam, SysPlatformUdcValueMngVO, Serializable> exportExcelService) {
//        this.exportExcelService = exportExcelService;
//    }
//
//
//}
