package com.elitescloud.cloudt.platform.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformUdcValueDO;
import com.elitescloud.cloudt.platform.model.params.udc.AddUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.AddUdcValueParam;
import com.elitescloud.cloudt.platform.model.params.udc.UdcValueSaveVO;
import com.elitescloud.cloudt.platform.model.params.udc.UpdateUdcParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueVO;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

@Mapper(config = BaseMapperConfig.class)
public interface UdcConvert {

    UdcConvert INSTANCE = Mappers.getMapper(UdcConvert.class);


    /**
     * saveParam转DO
     * @param param
     * @return
     */
    SysPlatformUdcDO saveParamToDo(AddUdcParam param);

    void copySaveVo2Do(UdcValueSaveVO saveVO, @MappingTarget SysPlatformUdcValueDO valueDO);


    /**
     * saveParam转DO
     * @param param
     * @return
     */
    SysPlatformUdcValueDO saveParamToDo(AddUdcValueParam param);

    /**
     * saveParam转DO
     * @param objDo
     * @return
     */
    SysPlatformUdcVO selectDOToVO(SysPlatformUdcDO objDo);

    /**
     * saveParam转DO
     * @param objDo
     * @return
     */
    SysPlatformUdcValueVO selectDOToVO(SysPlatformUdcValueDO objDo);

    /**
     * saveParam转DO
     * @param param
     * @return
     */
    SysPlatformUdcDO updateParamToDo(UpdateUdcParam param);
}
