package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.app.AddAppParam;
import com.elitescloud.cloudt.platform.model.params.app.QueryAppParam;
import com.elitescloud.cloudt.platform.model.params.app.UpdateAppParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformAppVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAppService;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Slf4j
@RestController
@Api(value = "平台应用管理", tags = {"平台应用管理"})
@RequestMapping("/sys/platform/app")
@BusinessObject(businessType = BusinessObjectConstant.SYS_PLATFORM_APP)
public class SysPlatformAppController {

    private final SysPlatformAppService sysPlatformAppService;

    public SysPlatformAppController(SysPlatformAppService sysPlatformAppService) {
        this.sysPlatformAppService = sysPlatformAppService;
    }

    @PostMapping("/addApp")
    @ApiOperation(value = "添加应用", notes = "平台应用管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.ADD,operationDescription = "添加应用"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Long> addApp(@RequestBody @Valid AddAppParam addAppParam) {
        return sysPlatformAppService.addApp(addAppParam);
    }

    @ApiOperation(value = "物理删除应用", notes = "平台应用管理")
    @PutMapping("/deleteFlagApp/{id}")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.DELETE,operationDescription = "删除应用"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> deleteFlagApp(@PathVariable Long id) {
        return sysPlatformAppService.deleteApp(id);
    }

    @PutMapping("/updateAppState/{id}/{state}")
    @ApiOperation(value = "更新应用是否启用状态", notes = "平台应用管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.UPDATE,operationDescription = "启用状态"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> updateAppState(@PathVariable Long id, @PathVariable Boolean state) {
        return sysPlatformAppService.updateAppState(id, state);
    }

    @PutMapping("/updateApp/{id}")
    @ApiOperation(value = "更新应用信息", notes = "平台应用管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.UPDATE,operationDescription = "更新应用信息"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> updateApp(@PathVariable Long id, @RequestBody UpdateAppParam updateAppParam) {
        return sysPlatformAppService.updateApp(id, updateAppParam);
    }

    @GetMapping("/getApp/{id}")
    @ApiOperation(value = "id查询应用", notes = "平台应用管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "删除菜单挂载API"
    )
    public ApiResult<SysPlatformAppVO> getApp(@PathVariable Long id) {
        return sysPlatformAppService.getApp(id);
    }

    @PostMapping("/queryApp")
    @ApiOperation(value = "分页查询应用", notes = "平台应用管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT_PAGE,operationDescription = "查询应用"
    )
    public ApiResult<PagingVO<SysPlatformAppVO>> queryApp(@RequestBody @Valid QueryAppParam queryAppParam) {
        return sysPlatformAppService.pageMng(queryAppParam);
    }

    @GetMapping("/getAllApps")
    @ApiOperation(value = "查询全部应用-已启用", notes = "平台应用管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "查询全部应用"
    )
    public ApiResult<List<CodeNameParam>> getAllApps() {
        return sysPlatformAppService.all();
    }

    @GetMapping("/enum/getAppTypeEnum")
    @ApiOperation(value = "应用类型枚举", notes = "平台应用管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "删除菜单挂载API"
    )
    public ApiResult<List<SysUdcVO>> getAppType() {
        return sysPlatformAppService.getAppType();
    }
}
