package com.elitescloud.cloudt.platform.model.entity;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.util.Objects;

/**
 * <pre>发号器规则明细</pre>
 *
 * @author Michael Li
 * 2020-10-10
 **/

@Entity
@Table(name = "sys_platform_number_ruledtl", indexes = {
    @Index(name = "idx_sysplatform_number_ruledtl_rule_id", columnList = "ruleId")
})
@org.hibernate.annotations.Table(appliesTo = "sys_platform_number_ruledtl", comment = "发号器规则明细")
@Data
@Accessors(chain = true)
@ApiModel(value = "发号器规则明细", description = "发号器规则明细")
public class SysPlatformNumberRuleDtlDO extends BaseStdModel {
    private static final long serialVersionUID = 2847171578260093086L;

    @Comment("应用编号")
    @Column(nullable = false)
    private String appCode;

    @Comment("规则编码")
    @Column()
    private String ruleCode;

    @Comment("发号器规则ID")
    @Column()
    private Long ruleId;
    
    @Comment(value = "排序号", defaultValue = "1")
    @Column()
    private Integer seq;
    
    @Comment("取号类型：sys:numbertype")
    @Column()
    private String numberType;
    
    @Comment("取号模式，根据取号类型填写对应的固定字符串、日期格式化字符串、自增序号码")
    @Column()
    private String numberPattern;

    @Comment("自增序号宽度，默认左补零")
    @Column()
    private Integer nnLen;
    
    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SysPlatformNumberRuleDtlDO)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SysPlatformNumberRuleDtlDO entity = (SysPlatformNumberRuleDtlDO) o;
        return getId().equals(entity.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getId());
    }
}
