package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Data
@Accessors(chain = true)
@ApiModel(value = "sys_platform_app", description = "平台应用管理")
public class SysPlatformAppVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -2305497711668367767L;

    @ApiModelProperty("应用编码")
    String appCode;

    @ApiModelProperty("应用名称")
    String appName;

    @ApiModelProperty("应用类型")
    String appType;

    @ApiModelProperty("描述")
    String appDescribe;

    @ApiModelProperty("状态")
    Boolean appState;

    @ApiModelProperty("排序")
    Integer appOrder;
}
