package com.elitescloud.cloudt.platform.model.vo.sequence;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 下一编号分页数据.
 *
 * @author Kaiser（wang shao）
 * 2022/9/19
 */
@Data
@ApiModel(description = "下一编号分页数据")
public class SysPlatformSeqNumPageRespVO implements Serializable {
    private static final long serialVersionUID = 7982719903841828956L;

    /**
     * 应用编码
     */
    @ApiModelProperty(value = "应用编码", position = 0)
    private String appCode;

    /**
     * ID
     */
    @ApiModelProperty(value = "ID", position = 1)
    private Long id;

    /**
     * 编号编码
     */
    @ApiModelProperty(value = "编号编码", position = 2)
    private String code;

    /**
     * 编号编码
     */
    @ApiModelProperty(value = "编号名称", position = 3)
    private String name;

    @ApiModelProperty(value = "下一编号步长")
    @NotNull
    Integer step;

    @ApiModelProperty(value = "下一编号取值")
    @NotNull
    Long nextNumber;

    @ApiModelProperty(value = "下一编号周期[UDC]SYS:NNPERIOD")
    String nnPeriod;
    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 5)
    private Boolean enabled;

    /**
     * 是否系统内置
     */
    @ApiModelProperty(value = "是否系统内置", position = 6)
    private Boolean internal;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", position = 7)
    private LocalDateTime createTime;

    /**
     * 最后修改时间
     */
    @ApiModelProperty(value = "最后修改时间", position = 8)
    private LocalDateTime modifyTime;
}
