package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusApiDO;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import com.elitescloud.cloudt.platform.model.params.menus.QueryMenusParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusApiVO;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.JPAExpressions;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2022/10/17
 */
@Repository
public class SysPlatformMenusRepoProc extends BaseRepoProc<SysPlatformMenusDO> {
    private static final QSysPlatformMenusDO QDO = QSysPlatformMenusDO.sysPlatformMenusDO;
    private static final QSysPlatformMenusApiDO QAPI = QSysPlatformMenusApiDO.sysPlatformMenusApiDO;

    public SysPlatformMenusRepoProc() {
        super(QDO);
    }

    public String getAppCode(String menusCode) {
        return jpaQueryFactory.select(QDO.menusAppCode)
                .from(QDO)
                .where(QDO.menusCode.eq(menusCode))
                .limit(1)
                .fetchOne();
    }

    /****
     * 查询菜单和菜单的api个数。 采用嵌套查询 原来是循环效率低。
     * @param appCode
     * @return
     */
    public List<SysPlatformMenusApiVO> getMenusSumApi(String appCode) {
        Expression<Long> apiNumExpr = JPAExpressions.select(QAPI.id.count().as("apiNum"))
                .from(QAPI)
                .where(QAPI.menusId.eq(QDO.id));

        return jpaQueryFactory.select(
                        Projections.constructor(
                                SysPlatformMenusApiVO.class,
                                QDO,
                                apiNumExpr
                        )
                )
                .from(QDO)
                .where(QDO.menusAppCode.eq(appCode).and(QDO.deleteFlag.eq(0)))
                .fetch();
    }

    /**
     * 根据应用编码删除
     *
     * @param appCode 应用编码
     */
    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue(QDO.menusAppCode, appCode);
    }

    /**
     * 获取菜单列表管理
     *
     * @param queryMenusParam 查询参数
     * @return 菜单列表
     */
    public List<SysPlatformMenusDO> queryListMng(QueryMenusParam queryMenusParam) {
        var predicate = PredicateBuilder.builder()
                .andEq(QDO.menusAppCode, queryMenusParam.getAppCode())
                .andLike(QDO.menusName, queryMenusParam.getMenusName())
                .andLike(QDO.menusCode, queryMenusParam.getMenusCode())
                .and(queryMenusParam.getMenusType() != null, () -> QDO.menusType.eq(queryMenusParam.getMenusType().name()))
                .andEq(QDO.menusState, queryMenusParam.getMenusState())
                .andEq(QDO.nodeType, queryMenusParam.getNodeType())
                .build();
        return super.getList(predicate)
                .stream()
                .sorted(Comparator.comparing(SysPlatformMenusDO::getMenusOrder, Comparator.nullsFirst(Integer::compareTo).reversed()))
                .collect(Collectors.toList());
    }

    /**
     * 根据菜单编码获取菜单信息
     *
     * @param menusCode 菜单编码
     * @return 菜单信息
     */
    public SysPlatformMenusDO getByMenusCode(@NotBlank String menusCode) {
        return super.getOneByValue(QDO.menusCode, menusCode);
    }
}
