package com.elitescloud.cloudt.platform.service.repo.number;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformNextNumberDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformNextNumberDO;
import com.querydsl.core.types.dsl.EntityPathBase;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <pre></pre>
 *
 * @author Michael Li
 * 2020-10-11
 */
@Repository
public class SysPlatformNextNumberRepoProc extends BaseRepoProc<SysPlatformNextNumberDO> {
    private static final QSysPlatformNextNumberDO QDO = QSysPlatformNextNumberDO.sysPlatformNextNumberDO;

    public SysPlatformNextNumberRepoProc() {
        super(QDO);
    }

    /**
     * 根据应用编码删除
     *
     * @param appCode 应用编码
     */
    public void deleteByApp(@NotBlank String appCode) {
        super.deleteByValue(QDO.appCode, appCode);
    }
}
