/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.app.AddAppParam;
import com.elitescloud.cloudt.platform.model.params.app.QueryAppParam;
import com.elitescloud.cloudt.platform.model.params.app.UpdateAppParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformAppVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAppService;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u5e73\u53f0\u5e94\u7528\u7ba1\u7406", tags={"\u5e73\u53f0\u5e94\u7528\u7ba1\u7406"})
@RequestMapping(value={"/sys/platform/app"})
@BusinessObject(businessType="SysPlatformApp:\u5e94\u7528")
public class SysPlatformAppController {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformAppController.class);
    private final SysPlatformAppService sysPlatformAppService;

    public SysPlatformAppController(SysPlatformAppService sysPlatformAppService) {
        this.sysPlatformAppService = sysPlatformAppService;
    }

    @PostMapping(value={"/addApp"})
    @ApiOperation(value="\u6dfb\u52a0\u5e94\u7528", notes="\u5e73\u53f0\u5e94\u7528\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.ADD, operationDescription="\u6dfb\u52a0\u5e94\u7528", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> addApp(@RequestBody @Valid AddAppParam addAppParam) {
        return this.sysPlatformAppService.addApp(addAppParam);
    }

    @ApiOperation(value="\u7269\u7406\u5220\u9664\u5e94\u7528", notes="\u5e73\u53f0\u5e94\u7528\u7ba1\u7406")
    @PutMapping(value={"/deleteFlagApp/{id}"})
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u5e94\u7528", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> deleteFlagApp(@PathVariable Long id) {
        return this.sysPlatformAppService.deleteApp(id);
    }

    @PutMapping(value={"/updateAppState/{id}/{state}"})
    @ApiOperation(value="\u66f4\u65b0\u5e94\u7528\u662f\u5426\u542f\u7528\u72b6\u6001", notes="\u5e73\u53f0\u5e94\u7528\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u542f\u7528\u72b6\u6001", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> updateAppState(@PathVariable Long id, @PathVariable Boolean state) {
        return this.sysPlatformAppService.updateAppState(id, state);
    }

    @PutMapping(value={"/updateApp/{id}"})
    @ApiOperation(value="\u66f4\u65b0\u5e94\u7528\u4fe1\u606f", notes="\u5e73\u53f0\u5e94\u7528\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.UPDATE, operationDescription="\u66f4\u65b0\u5e94\u7528\u4fe1\u606f", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Boolean> updateApp(@PathVariable Long id, @RequestBody UpdateAppParam updateAppParam) {
        return this.sysPlatformAppService.updateApp(id, updateAppParam);
    }

    @GetMapping(value={"/getApp/{id}"})
    @ApiOperation(value="id\u67e5\u8be2\u5e94\u7528", notes="\u5e73\u53f0\u5e94\u7528\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u5220\u9664\u83dc\u5355\u6302\u8f7dAPI")
    public ApiResult<SysPlatformAppVO> getApp(@PathVariable Long id) {
        return this.sysPlatformAppService.getApp(id);
    }

    @PostMapping(value={"/queryApp"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5e94\u7528", notes="\u5e73\u53f0\u5e94\u7528\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u67e5\u8be2\u5e94\u7528")
    public ApiResult<PagingVO<SysPlatformAppVO>> queryApp(@RequestBody @Valid QueryAppParam queryAppParam) {
        return this.sysPlatformAppService.pageMng(queryAppParam);
    }

    @GetMapping(value={"/getAllApps"})
    @ApiOperation(value="\u67e5\u8be2\u5168\u90e8\u5e94\u7528-\u5df2\u542f\u7528", notes="\u5e73\u53f0\u5e94\u7528\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u67e5\u8be2\u5168\u90e8\u5e94\u7528")
    public ApiResult<List<CodeNameParam>> getAllApps() {
        return this.sysPlatformAppService.all();
    }

    @GetMapping(value={"/enum/getAppTypeEnum"})
    @ApiOperation(value="\u5e94\u7528\u7c7b\u578b\u679a\u4e3e", notes="\u5e73\u53f0\u5e94\u7528\u7ba1\u7406")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u5220\u9664\u83dc\u5355\u6302\u8f7dAPI")
    public ApiResult<List<SysUdcVO>> getAppType() {
        return this.sysPlatformAppService.getAppType();
    }
}

