/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.convert.UdcConvert;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformUdcDO;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcValueParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueMngVO;
import com.elitescloud.cloudt.platform.service.SysPlatformUdcMngService;
import com.elitescloud.cloudt.platform.service.impl.SysPlatformAppServiceImpl;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcRepo;
import com.elitescloud.cloudt.platform.service.repo.SysPlatformUdcValueMngRepo;
import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;

@Service
public class SysPlatformUdcMngServiceImpl
extends BaseServiceImpl
implements SysPlatformUdcMngService {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformUdcMngServiceImpl.class);
    final SysPlatformUdcValueMngRepo sysPlatformUdcValueMngRepo;
    final SysPlatformUdcRepo sysPlatformUdcRepo;
    @Autowired
    final SysPlatformAppServiceImpl sysPlatformAppService;

    @Override
    public PagingVO<SysPlatformUdcVO> queryUdc(QueryUdcParam param) {
        SysPlatformUdcValueMngVO sysPlatformUdcValueMngVO;
        if ((StringUtils.hasText((String)param.getUdcValueName()) || StringUtils.hasText((String)param.getUdcValueCode())) && (sysPlatformUdcValueMngVO = this.sysPlatformUdcValueMngRepo.queryUdcCode(param)) != null) {
            param.setUdcCode(sysPlatformUdcValueMngVO.getUdcCode());
        }
        QSysPlatformUdcDO qdo = QSysPlatformUdcDO.sysPlatformUdcDO;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> ((StringPath)qdo.appCode).eq(arg_0), (Object)param.getAppCode()).and(arg_0 -> ((StringPath)qdo.udcName).like(arg_0), StringUtils.hasText((String)param.getUdcName()) ? "%" + param.getUdcName() + "%" : null).and(arg_0 -> ((StringPath)qdo.udcCode).like(arg_0), StringUtils.hasText((String)param.getUdcCode()) ? "%" + param.getUdcCode() + "%" : null).getPredicate();
        Page page = this.sysPlatformUdcRepo.findAll(predicate, (Pageable)param.getPageRequest());
        PagingVO pagingVo = PagingVO.builder().total(page.getTotalElements()).setRecords(page.get().map(UdcConvert.INSTANCE::selectDOToVO).collect(Collectors.toList()));
        return pagingVo;
    }

    @Override
    public List<SysPlatformUdcValueMngVO> queryUdcValue(@RequestBody HashMap<String, Object> param) {
        Assert.notNull((Object)param.get("appCode").toString(), (String)"\u5e94\u7528\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.notNull((Object)param.get("udcCode").toString(), (String)"udc\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<SysPlatformUdcValueMngVO> udcValueMngVOList = this.sysPlatformUdcValueMngRepo.queryUdcValueList(param);
        if (CollectionUtils.isEmpty(udcValueMngVOList)) {
            return null;
        }
        return udcValueMngVOList;
    }

    @Override
    public PagingVO<SysPlatformUdcValueMngVO> getUdcValuePage(QueryUdcValueParam param) {
        PagingVO<SysPlatformUdcValueMngVO> udcValuePage = this.sysPlatformUdcValueMngRepo.getUdcValuePage(param);
        if (udcValuePage.isEmpty()) {
            return udcValuePage;
        }
        List codeNameParamList = (List)this.sysPlatformAppService.all().getData();
        if (!CollectionUtils.isEmpty((Collection)codeNameParamList)) {
            udcValuePage.getRecords().forEach(n -> codeNameParamList.stream().filter(m -> m.getCode().equals(n.getAppCode())).findFirst().ifPresent(opt -> n.setAppName(opt.getName())));
        }
        return udcValuePage;
    }

    public SysPlatformUdcMngServiceImpl(SysPlatformUdcValueMngRepo sysPlatformUdcValueMngRepo, SysPlatformUdcRepo sysPlatformUdcRepo, SysPlatformAppServiceImpl sysPlatformAppService) {
        this.sysPlatformUdcValueMngRepo = sysPlatformUdcValueMngRepo;
        this.sysPlatformUdcRepo = sysPlatformUdcRepo;
        this.sysPlatformAppService = sysPlatformAppService;
    }
}

