package com.elitescloud.cloudt.platform.controller.api;

import cn.hutool.core.collection.ListUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.platform.model.constant.PlatformRequestTypeEnum;
import com.elitescloud.cloudt.platform.model.params.api.AddApiPermissionParam;
import com.elitescloud.cloudt.platform.model.params.api.GetApiPermissionParam;
import com.elitescloud.cloudt.platform.model.vo.GetAppMenusVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformApiPermissionVO;
import com.elitescloud.cloudt.platform.service.SysPlatformApiPermissionService;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import springfox.documentation.annotations.ApiIgnore;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Set;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Slf4j
@RestController
@Api(value = "平台api权限管理", tags = {"【不使用】平台api权限管理"})
@ApiIgnore
@RequestMapping("/sys/platform/apiPermission")
public class SysPlatformApiPermissionController {

    private final SysPlatformApiPermissionService sysPlatformApiPermissionService;

    public SysPlatformApiPermissionController(SysPlatformApiPermissionService sysPlatformApiPermissionService) {
        this.sysPlatformApiPermissionService = sysPlatformApiPermissionService;
    }

    /**
     * 添加管理员菜单 全删全插
     **/
    @PostMapping("/addApiPermission")
    @ApiOperation(value = "添加应用API权限", notes = "平台api权限管理")
    public ApiResult<Long> addApiPermission(@RequestBody @Validated AddApiPermissionParam addApiPermission) {
        return sysPlatformApiPermissionService.addApiPermission(addApiPermission);
    }


    @GetMapping("/getApiPermission")
    @ApiOperation(value = "返回应用API权限", notes = "平台api权限管理")
    public ApiResult<List<SysPlatformApiPermissionVO>> getApiPermission(
            @RequestParam(value = "menusCode") @NotBlank(message = "菜单编码空") String menusCode
           ) {
        return sysPlatformApiPermissionService.getApiPermission(menusCode);
    }


    @DeleteMapping("/delete/{id}")
    @ApiOperation(value = "删除应用API权限", notes = "平台api权限管理")
    public ApiResult<Boolean> deleteApiPermission(@PathVariable Long id) {
        return sysPlatformApiPermissionService.deleteApiPermission(id);
    }



    @GetMapping("/enum/PlatformRequestTypeEnum")
    @ApiOperation(value = "请求类型枚举", notes = "平台api权限管理")
    public ApiResult<List<SysUdcVO>> getPlatformRequestTypeEnum() {
       List<SysUdcVO> list=  ListUtil.<SysUdcVO>toList(PlatformRequestTypeEnum.POST.getUdcVO(),
                PlatformRequestTypeEnum.GET.getUdcVO(),
                PlatformRequestTypeEnum.PUT.getUdcVO(),
                PlatformRequestTypeEnum.PATCH.getUdcVO(),
                PlatformRequestTypeEnum.DELETE.getUdcVO());
      return ApiResult.ok(list);
    }


}
