//
//package com.elitescloud.cloudt.platform.controller.api;
//
//import com.elitescloud.boot.exception.BusinessException;
//import com.elitescloud.cloudt.common.base.ApiResult;
//import com.elitescloud.cloudt.common.base.PagingVO;
//import com.elitescloud.cloudt.platform.convert.SysPlatformSqlExecuteConvert;
//import com.elitescloud.cloudt.platform.model.entity.QSysPlatformSqlExecuteDO;
//import com.elitescloud.cloudt.platform.model.entity.SysPlatformSqlExecuteDO;
//import com.elitescloud.cloudt.platform.model.params.sql.SysPlatformSqlExecuteParam;
//import com.elitescloud.cloudt.platform.service.repo.SysPlatformSqlExecuteRepo;
//import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
//import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
//import io.swagger.annotations.Api;
//import io.swagger.annotations.ApiOperation;
//import lombok.extern.slf4j.Slf4j;
//import org.springframework.util.StringUtils;
//import org.springframework.web.bind.annotation.*;
//
//import javax.validation.Valid;
//import java.util.List;
//import java.util.stream.Collectors;
//
///**
// * @author : chen.niu
// * @description : 通用sql执行
// * @date : 2023/10/25 10:44
// */
//
//@Slf4j
//@RestController
//@Api(value = "平台通用sql执行", tags = {"平台通用sql执行"})
//@RequestMapping("/sys/platform/tenantApp")
//public class SysPlatformDatabaseSourceController {
//
//    private final SysPlatformSqlExecuteRepo sqlExecuteRepo;
//
//    public SysPlatformDatabaseSourceController(SysPlatformSqlExecuteRepo sqlExecuteRepo) {
//        this.sqlExecuteRepo = sqlExecuteRepo;
//    }
//
//
//    /**
//     * 分页查询记录
//     *
//     * @param queryVO 查询参数
//     * @return 分页数据
//     */
//    @ApiOperation(value = "分页查询记录")
//    @ApiOperationSupport(order = 1)
//    @PostMapping(value = "/page")
//    public ApiResult<PagingVO<SysPlatformSqlExecuteDO>> page(@RequestBody SysPlatformSqlExecuteParam queryVO) {
//        var QDO = QSysPlatformSqlExecuteDO.sysPlatformSqlExecuteDO;
//        var predicate=   JpaPredicateBuilder.builder()
//                .and(QDO.datasourceName::like, StringUtils.hasText(queryVO.getDatasourceName()) ? "%" + queryVO.getDatasourceName() + "%" : null)
//                .and(QDO.sqlName::like, StringUtils.hasText(queryVO.getSqlName()) ? "%" + queryVO.getSqlName() + "%" : null)
//                .and(QDO.querySql::like, StringUtils.hasText(queryVO.getQuerySql()) ? "%" + queryVO.getQuerySql() + "%" : null)
//                .getPredicate()
//        ;
//        var page = sqlExecuteRepo.findAll(predicate, queryVO.getPageRequest());
//        var pagingVo = PagingVO.<SysPlatformSqlExecuteDO>builder()
//                .total(page.getTotalElements())
//                .setRecords(page.get().collect(Collectors.toList()));
//        return ApiResult.ok(pagingVo);
//
//    }
//
//    @PostMapping("/add")
//    @ApiOperation(value = "添加", notes = "")
//    public ApiResult<Long> addMenus(@RequestBody @Valid SysPlatformSqlExecuteParam addParam) {
//       var addDo= SysPlatformSqlExecuteConvert.INSTANCE.voToDo(addParam);
//        sqlExecuteRepo.save(addDo);
//        return ApiResult.ok(addDo.getId());
//    }
////
//    @PutMapping("/update/{id}")
//    @ApiOperation(value = "更新")
//    public ApiResult<Boolean> updateMenus(@PathVariable Long id, @RequestBody SysPlatformSqlExecuteParam updateParam) {
//        sqlExecuteRepo.findById(id).ifPresentOrElse(manageDO -> {
//                    manageDO.setQuerySql(updateParam.getQuerySql());
//                    manageDO.setSqlName(updateParam.getSqlName());
//                    manageDO.setDatasourceName(updateParam.getDatasourceName());
//                     sqlExecuteRepo.save(manageDO);
//                },
//                () -> {
//                    throw new BusinessException("id不存在");
//                });
//        return ApiResult.ok(true);
//
//
//    }
//    @GetMapping("/getById/{id}")
//    @ApiOperation(value = "id查询")
//    public ApiResult<SysPlatformSqlExecuteDO> getMenus(@PathVariable Long id) {
//        var sqlDo=sqlExecuteRepo.findById(id);
//        if (sqlDo.isPresent()){
//            return ApiResult.ok(sqlDo.get());
//        }else {
//            return ApiResult.ok();
//        }
//    }
//    @PutMapping("/delete")
//    @ApiOperation(value = "删除", notes = "删除")
//    public ApiResult<Boolean> deleteByIds(@RequestBody List<Long> ids) {
//        sqlExecuteRepo.deleteAllById(ids);
//        return ApiResult.ok();
//    }
//
//}
