package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.platform.model.params.menus.*;
import com.elitescloud.cloudt.platform.model.vo.GetAppMenusVO;
import com.elitescloud.cloudt.platform.model.vo.MenusApiVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusApiVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformMenusVO;
import com.elitescloud.cloudt.platform.service.SysPlatformMenusService;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectConstant;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectEnum;
import com.elitescloud.cloudt.system.vo.SysUdcVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.List;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Slf4j
@RestController
@Api(value = "平台菜单", tags = {"平台菜单管理"})
@RequestMapping("/sys/platform/menus")
@BusinessObject(businessType = BusinessObjectEnum.SYS_PLATFORM_MENUS)
public class SysPlatformMenusController {

    private final SysPlatformMenusService sysPlatformMenusService;

    public SysPlatformMenusController(SysPlatformMenusService sysPlatformMenusService) {
        this.sysPlatformMenusService = sysPlatformMenusService;
    }


    @PostMapping("/addMenus")
    @ApiOperation(value = "添加菜单", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.ADD,operationDescription = "添加菜单"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Long> addMenus(@RequestBody @Valid AddMenusParam addMenusParam) {
        return sysPlatformMenusService.addMenus(addMenusParam);
    }

    @PutMapping("/updateMenus/{id}")
    @ApiOperation(value = "更新菜单信息", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.UPDATE,operationDescription = "更新菜单信息"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> updateMenus(@PathVariable Long id, @RequestBody UpdateMenusParam updateMenusParam) {
        return sysPlatformMenusService.updateMenus(id, updateMenusParam);
    }

    @PostMapping("/addButton")
    @ApiOperation(value = "添加按钮", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.ADD,operationDescription = "添加按钮"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Long> addButton(@RequestBody @Valid AddButtonParam addButtonParam) {
        return sysPlatformMenusService.addButton(addButtonParam);
    }

    @PutMapping("/updateButton/{id}")
    @ApiOperation(value = "更新按钮信息", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.UPDATE,operationDescription = "更新按钮信息"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> updateButton(@PathVariable Long id, @RequestBody UpdateButtonParam updateMenusParam) {
        return sysPlatformMenusService.updateButton(id, updateMenusParam);
    }

    @PostMapping("/addMenusGroup")
    @ApiOperation(value = "添加菜单分组", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.ADD,operationDescription = "添加菜单分组"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Long> addMenusGroup(@RequestBody @Valid AddMenusParam addMenusParam) {
        return sysPlatformMenusService.addMenusGroup(addMenusParam);
    }

    @PutMapping("/updateMenusGroup/{id}")
    @ApiOperation(value = "更新菜单分组信息", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.UPDATE,operationDescription = "更新菜单分组"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> updateMenusGroup(@PathVariable Long id, @RequestBody UpdateMenusParam updateMenusParam) {
        return sysPlatformMenusService.updateMenusGroup(id, updateMenusParam);
    }

    @PostMapping("/addFormMenus")
    @ApiOperation(value = "添加表单菜单", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.ADD,operationDescription = "添加表单菜单"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Long> addFormMenus(@RequestBody @Valid AddFormMenusParam addMenusParam) {
        return sysPlatformMenusService.addFormMenus(addMenusParam);
    }

    @PutMapping("/updateFormMenus/{id}")
    @ApiOperation(value = "更新表单菜单", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.UPDATE,operationDescription = "更新表单菜单"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> updateFormMenus(@PathVariable Long id, @RequestBody UpdateFormMenusParam updateMenusParam) {
        return sysPlatformMenusService.updateFormMenus(id, updateMenusParam);
    }


    @ApiOperation(value = "物理删除菜单", notes = "平台菜单管理")
    @PutMapping("/deleteFlagMenus/{id}")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.DELETE,operationDescription = "删除菜单"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> deleteFlagMenus(@PathVariable Long id) {
        // return sysPlatformMenusService.deleteFlagMenus(id);
        return sysPlatformMenusService.deleteMenus(id);
    }

//    @ApiOperation(value = "删除菜单", notes = "平台菜单管理")
//    @DeleteMapping("/delete/{id}")
//    public ApiResult<Boolean> deleteMenus(@PathVariable Long id) {
//        return sysPlatformMenusService.deleteMenus(id);
//    }

    @PutMapping("/updateMenusState/{id}/{state}")
    @ApiOperation(value = "更新菜单是否启用状态", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.UPDATE,operationDescription = "启用状态"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> updateMenusState(@PathVariable Long id, @PathVariable Boolean state) {
        return sysPlatformMenusService.updateMenusState(id, state);
    }


    @GetMapping("/getMenus/{id}")
    @ApiOperation(value = "id查询菜单", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "查询菜单"
    )
    public ApiResult<SysPlatformMenusVO> getMenus(@PathVariable Long id) {
        return sysPlatformMenusService.getMenus(id);
    }

    @GetMapping("/getSysAppMenus")
    @ApiOperation(value = "返回系统应用和系统菜单数据-状态都是启用", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.UPDATE,operationDescription = "系统菜单启用数据"
    )
    public ApiResult<GetAppMenusVO> getSysAppMenus() {

        return sysPlatformMenusService.getSysBusAppMenus(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS);
    }

    @GetMapping("/getBusAppMenus")
    @ApiOperation(value = "返回业务应用和业务菜单数据-状态都是启用", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "业务菜单启用数据"
    )
    public ApiResult<GetAppMenusVO> getBusAppMenus() {
        return sysPlatformMenusService.getSysBusAppMenus(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS);
    }

    @GetMapping("/getSysAppMenusAll")
    @ApiOperation(value = "返回系统应用的系统菜单数据-状态启用和非启用", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "系统应用的系统菜单"
    )
    public ApiResult<GetAppMenusVO> getSysAppMenusAll() {

        return sysPlatformMenusService.getSysAppMenusAll(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS);
    }

    @GetMapping("/getBusAppMenusAll")
    @ApiOperation(value = "返回业务应用和业务菜单数据-状态启用和非启用", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "业务应用和业务菜单"
    )
    public ApiResult<GetAppMenusVO> getBusAppMenusAll() {
        return sysPlatformMenusService.getSysAppMenusAll(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS);
    }

    /**
     * 返回全部应用和菜单数据
     **/
    @GetMapping("/getAllAppMenus")
    @ApiOperation(value = "返回全部应用和菜单-状态启用和非启用", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "返回全部应用和菜单"
    )
    public ApiResult<GetAppMenusVO> getAllAppMenus() {
        return sysPlatformMenusService.getAllAppMenus();
    }


    @PostMapping("/queryMenus")
    @ApiOperation(value = "查询菜单", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "查询菜单"
    )
    public ApiResult<List<SysPlatformMenusVO>> queryMenus(@RequestBody @Valid QueryMenusParam queryMenusParam) {
        return sysPlatformMenusService.queryMenus(queryMenusParam);
    }

    @GetMapping("/enum/getMenusTypeEnum")
    @ApiOperation(value = "菜单类型枚举", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "菜单类型枚举"
    )
    public ApiResult<List<SysUdcVO>> getMenusTypeEnum() {
        return sysPlatformMenusService.getMenusTypeEnum();
    }

    @GetMapping("/enum/getPlatformMenusOuterLinkTypeEnum")
    @ApiOperation(value = "菜单外链类型枚举", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "菜单外链类型枚举"
    )
    public ApiResult<List<SysUdcVO>> getPlatformMenusOuterLinkTypeEnum() {
        return sysPlatformMenusService.getPlatformMenusOuterLinkTypeEnum();
    }

    @GetMapping("/getAllAppMenusApi/{appCode}")
    @ApiOperation(value = "查询应用菜单", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "查询应用菜单"
    )
    public ApiResult<List<SysPlatformMenusApiVO>> getAllAppMenusApi(@PathVariable String appCode) {
        return sysPlatformMenusService.getAllAppMenusApi(appCode);
    }

    @PostMapping("/api/add")
    @ApiOperation(value = "添加菜单挂载API接口", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.ADD,operationDescription = "添加菜单挂载API"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> addMenusApi(@RequestBody AddMenusApiParam addMenusApiParam) {
        return sysPlatformMenusService.addMenusApi(addMenusApiParam);
    }

    @PutMapping("/deleteMenusApi")
    @ApiOperation(value = "删除菜单挂载API接口", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.DELETE,operationDescription = "删除菜单挂载API"
            , logEnabled = true,  argsJsonEnabled = true,resultJsonEnabled = true
    )
    public ApiResult<Boolean> deleteMenusApi(@RequestBody DeleteMenusApiParam deleteMenusApiParam) {
        return sysPlatformMenusService.deleteMenusApi(deleteMenusApiParam);
    }

    @PostMapping("/api/{appId}/{menusId}")
    @ApiOperation(value = "查询菜单挂载API接口", notes = "平台菜单管理")
    @BusinessObjectOperation(
            operationType = OperationTypeEnum.SELECT,operationDescription = "查询菜单挂载API"
    )
    public ApiResult<List<MenusApiVO>> getMenusApis(@PathVariable Long appId, @PathVariable Long menusId) {
        return sysPlatformMenusService.getMenusApis(appId, menusId);
    }
}
