package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(name = TableNameConstant.SYS_PLATFORM_API_PARAMETER)
@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_PLATFORM_API_PARAMETER, comment = "接口字段")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value = TableNameConstant.SYS_PLATFORM_API_PARAMETER, description = "接口字段")
public class SysPlatformApiParameterDO extends BaseStdModel {
    private static final long serialVersionUID = -8115622484131968718L;

    public static final String TYPE_IN = "IN";
    public static final String TYPE_OUT = "OUT";

    @Comment("字段所属接口id")
    @Column
    private Long apiId;

    @Comment("字段所属接口编码")
    @Column
    private String apiCode;

    @Comment("字段名称")
    @Column
    private String fieldName;

    @Comment("字段类型")
    @Column
    private String fieldType;

    @Comment("字段是否可以为空")
    @Column
    private Boolean fieldIsNull;

    @Comment("字段说明")
    @Column
    private String fieldExplain;

    @Comment("备注")
    @Column
    private String remark;

    @Comment("字段类型")
    @Column()
    private String inOutType;
}
