package com.elitescloud.cloudt.platform.model.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusOuterLinkTypeEnum;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import com.elitescloud.cloudt.system.service.model.BaseStdModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;
import org.hibernate.Hibernate;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.util.Objects;

/**
 * @Description:
 * @author: niu.chen
 * @date: 2022.09.15
 **/
@Entity
@org.hibernate.annotations.Table(appliesTo = TableNameConstant.SYS_PLATFORM_MENUS, comment = "平台菜单表")
@Getter
@Setter
@ToString
@RequiredArgsConstructor
@DynamicInsert
@DynamicUpdate
@Where(clause = "delete_flag = 0 or delete_flag is null")
@Accessors(chain = true)
@ApiModel(value =  TableNameConstant.SYS_PLATFORM_MENUS, description = "平台菜单表")
@Table(name =  TableNameConstant.SYS_PLATFORM_MENUS, indexes = {
        @Index(name = "idx_menu_code", columnList = "menusCode", unique = true)
})
public class SysPlatformMenusDO extends BaseStdModel {
    private static final long serialVersionUID = -4869623354882616900L;

    @Comment("菜单归属应用")
    @Column
    private String menusAppCode;

    @Comment("菜单名称")
    @Column
    private String menusName;

    @Comment("菜单类型")
    @Column
    private String menusType;

    @Comment("节点类型")
    @Column
    private String nodeType;

    @Comment("菜单编码")
    @Column
    private String menusCode;

    @Comment(value = "排序", defaultValue = "0")
    @Column()
    private Integer menusOrder;

    @Comment(value = "菜单状态", defaultValue = "1")
    @Column()
    private Boolean menusState;

    @Comment("上级菜单编码")
    @Column
    private String menusParentCode;

    @Comment("菜单路由")
    @Column
    private String menusRoute;

    @Comment("描述")
    @Column
    private String menusDescribe;

    @Comment("图标")
    @Column
    private String menusIcon;

    @Comment(value = "是否展示", defaultValue = "1")
    @Column()
    private Boolean display;

    @Comment(value = "是否外链接", defaultValue = "0")
    @Column()
    private Boolean outerLink;

    @Comment("外链接类型")
    @Column()
    @Enumerated(EnumType.STRING)
    private PlatformMenusOuterLinkTypeEnum outerLinkType;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || Hibernate.getClass(this) != Hibernate.getClass(o)) {
            return false;
        }
        SysPlatformMenusDO that = (SysPlatformMenusDO) o;
        return getId() != null && Objects.equals(getId(), that.getId());
    }

    @Override
    public int hashCode() {
        return getClass().hashCode();
    }
}
