package com.elitescloud.cloudt.platform.model.vo;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.platform.model.constant.PlatformMenusOuterLinkTypeEnum;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformMenusDO;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel(value = "sys_platform_menus_api", description = "平台菜单接口表")
public class SysPlatformMenusApiVO extends BaseViewModel implements Serializable {
    private static final long serialVersionUID = -8155768804180727511L;

    public SysPlatformMenusApiVO() {
    }

    public SysPlatformMenusApiVO(SysPlatformMenusDO sysPlatformMenusDO, Long apiNum
    ) {
        this.setId(sysPlatformMenusDO.getId());
        this.menusAppCode = sysPlatformMenusDO.getMenusAppCode();
        this.menusName = sysPlatformMenusDO.getMenusName();
        this.menusType = sysPlatformMenusDO.getMenusType();
        this.nodeType = sysPlatformMenusDO.getNodeType();
        this.menusCode = sysPlatformMenusDO.getMenusCode();
        this.menusOrder = sysPlatformMenusDO.getMenusOrder();
        this.menusState = sysPlatformMenusDO.getMenusState();
        this.menusParentCode = sysPlatformMenusDO.getMenusParentCode();
        this.menusRoute = sysPlatformMenusDO.getMenusRoute();
        this.menusDescribe = sysPlatformMenusDO.getMenusDescribe();
        this.menusIcon = sysPlatformMenusDO.getMenusIcon();
        this.display = sysPlatformMenusDO.getDisplay();
        this.outerLink = sysPlatformMenusDO.getOuterLink();
        this.outerLinkType = sysPlatformMenusDO.getOuterLinkType();
        this.apiNum = apiNum;
    }

    @ApiModelProperty("菜单归属应用")
    String menusAppCode;

    @ApiModelProperty("菜单名称")
    String menusName;

    @ApiModelProperty("菜单类型")
    String menusType;
    @ApiModelProperty("节点类型 菜单,按钮")
    String nodeType;

    @ApiModelProperty("菜单编码")
    String menusCode;

    @ApiModelProperty("排序")
    Integer menusOrder;

    @ApiModelProperty("菜单状态")
    Boolean menusState;

    @ApiModelProperty("上级菜单编码")
    String menusParentCode;

    @ApiModelProperty("菜单路由")
    String menusRoute;

    @ApiModelProperty("描述")
    String menusDescribe;

    @ApiModelProperty("图标")
    String menusIcon;

    @ApiModelProperty("是否展示")
    Boolean display;
    @ApiModelProperty("是否外链接")
    Boolean outerLink;
    @ApiModelProperty("外链接类型")
    PlatformMenusOuterLinkTypeEnum outerLinkType;

    @ApiModelProperty("挂载api数量")
    Long apiNum;
}
