package com.elitescloud.cloudt.platform.model.vo.extend.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 货币分页查询结果.
 *
 * @author Kaiser（wang shao）
 * 2023/1/13
 */
@Data
@ApiModel(description = "货币分页查询结果")
public class CurrencyPageRespVO implements Serializable {
    private static final long serialVersionUID = 4223391849501276699L;

    /**
     * 记录唯一ID
     */
    @ApiModelProperty(value = "记录唯一ID", position = 1)
    private Long id;

    /**
     * 货币编码
     */
    @ApiModelProperty(value = "货币编码", position = 2)
    private String currCode;

    /**
     * 货币名称
     */
    @ApiModelProperty(value = "货币名称", position = 3)
    private String currName;

    /**
     * 小数位数
     */
    @ApiModelProperty(value = "小数位数", position = 4)
    private Integer dispDecimal;

    /**
     * 是否启用
     */
    @ApiModelProperty(value = "是否启用", position = 5)
    private Boolean enabled;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间", position = 6)
    private LocalDateTime createTime;
}
