package com.elitescloud.cloudt.platform.service;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformDatabaseSourceDO;
import com.elitescloud.cloudt.platform.model.params.datasource.SysPlatformDatabaseSourceSaveParam;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaMngTreeRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.PlatformAreaSaveVO;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/10/25 13:53
 */

public interface SysPlatformDatabaseSourceService {
    /**
     * 保存
     *
     * @param saveVO
     * @return
     */
    ApiResult<Long> select(SysPlatformDatabaseSourceSaveParam saveVO);

    /**
     * 保存
     *
     * @param saveVO
     * @return
     */
    ApiResult<Long> save(SysPlatformDatabaseSourceSaveParam saveVO);

    /**
     * 获取
     *
     * @param id  ID
     * @return
     */
    ApiResult<SysPlatformDatabaseSourceDO> get(@NotNull Long id);

    /**
     * 删除
     *
     * @param id  ID
     * @return  ID
     */
    ApiResult<Long> delete(@NotNull Long id);
}
