package com.elitescloud.cloudt.platform.service.repo;

import com.elitescloud.boot.jpa.common.BaseTreeRepoProc;
import com.elitescloud.cloudt.platform.model.entity.QSysPlatformAreaDO;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformAreaDO;
import org.springframework.stereotype.Repository;

import javax.validation.constraints.NotBlank;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * .
 *
 * @author Kaiser（wang shao）
 * 2023/1/17
 */
@Repository
public class SysPlatformAreaRepoProc extends BaseTreeRepoProc<SysPlatformAreaDO> {
    private static final QSysPlatformAreaDO QDO = QSysPlatformAreaDO.sysPlatformAreaDO;

    public SysPlatformAreaRepoProc() {
        super(QDO);
    }

    /**
     * 更新codePath
     *
     * @param id
     * @param codePath
     */
    public void updateCodePath(long id, @NotBlank String codePath) {
        super.jpaQueryFactory.update(QDO)
                .set(QDO.codePath, codePath)
                .where(QDO.id.eq(id))
                .execute();
    }

    /**
     * 判断地区编码是否存在
     *
     * @param areaCode
     * @param id
     * @return
     */
    public boolean existsAreaCode(@NotBlank String areaCode, Long id) {
        return super.exists(QDO.areaCode, areaCode, id);
    }

    /**
     * 根据编码获取ID
     *
     * @param areaCode
     * @return
     */
    public Long getId(@NotBlank String areaCode) {
        return super.getIdByValue(QDO.areaCode, areaCode);
    }

    /**
     * 获取地区名称
     *
     * @param id
     * @return
     */
    public String getAreaName(long id) {
        return super.getValue(QDO.areaName, id);
    }

    /**
     * 获取地区名称
     *
     * @param areaCode
     * @return
     */
    public String getAreaName(@NotBlank String areaCode) {
        return super.getValueByValue(QDO.areaName, QDO.areaCode, areaCode);
    }

    /**
     * 获取路径编码
     *
     * @param id
     * @return
     */
    public String getCodePath(long id) {
        return super.getValue(QDO.codePath, id);
    }

    /**
     * 获取路径编码
     *
     * @param areaCode
     * @return
     */
    public String getCodePath(@NotBlank String areaCode) {
        return super.getValueByValue(QDO.codePath, QDO.areaCode, areaCode);
    }

    /**
     * 获取符合codePath的id
     *
     * @param codePath
     * @return
     */
    public Map<Long, String> getIdAndCodePathByCodePath(@NotBlank String codePath) {
        return super.jpaQueryFactory.select(QDO.id, QDO.codePath)
                .from(QDO)
                .where(QDO.codePath.like(codePath + SysPlatformAreaDO.PATH_SEPARATOR + "%"))
                .fetch()
                .stream()
                .collect(Collectors.toMap(t -> t.get(QDO.id), t -> t.get(QDO.codePath), (t1, t2) -> t1));
    }

    /**
     * 获取编码与ID
     *
     * @return
     */
    public Map<String, Long> getIdAndCode() {
        return super.jpaQueryFactory.select(QDO.id, QDO.areaCode)
                .from(QDO)
                .fetch()
                .stream()
                .collect(Collectors.toMap(t -> t.get(QDO.areaCode), t -> t.get(QDO.id), (t1, t2) -> t1));
    }
}
