/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.controller.api;

import com.elitescloud.boot.excel.common.ExportExcelService;
import com.elitescloud.boot.excel.common.param.AbstractExportQueryParam;
import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcParam;
import com.elitescloud.cloudt.platform.model.params.udc.QueryUdcValueParam;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcVO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformUdcValueMngVO;
import com.elitescloud.cloudt.platform.service.SysPlatformUdcMngService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(value="\u5e73\u53f0udc", tags={"\u5e73\u53f0udc"})
@RequestMapping(value={"/sys/platform/udc/mng"})
@BusinessObject(businessType="SysPlatformUdc:\u5e73\u53f0UDC")
public class SysPlatformUdcMngController {
    private static final Logger log = LoggerFactory.getLogger(SysPlatformUdcMngController.class);
    @Autowired
    private SysPlatformUdcMngService sysPlatformUdcMngService;
    private ExportExcelService<QueryUdcValueParam, SysPlatformUdcValueMngVO, Serializable> exportExcelService;

    @PostMapping(value={"/queryUdc"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2UDC", notes="\u5e73\u53f0udc")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2UDC")
    public ApiResult<PagingVO<SysPlatformUdcVO>> queryUdc(@RequestBody @Valid QueryUdcParam queryUdcParam) {
        PagingVO<SysPlatformUdcVO> page = this.sysPlatformUdcMngService.queryUdc(queryUdcParam);
        return ApiResult.ok(page);
    }

    @PostMapping(value={"/queryUdcValue"})
    @ApiOperation(value="\u67e5\u8be2UDC\u503c", notes="\u5e73\u53f0udc")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u67e5\u8be2UDC\u503c")
    public ApiResult<List<SysPlatformUdcValueMngVO>> queryUdcValue(@RequestBody HashMap<String, Object> param) {
        return ApiResult.ok(this.sysPlatformUdcMngService.queryUdcValue(param));
    }

    @PostMapping(value={"/queryUdcValueList"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2UDC\u503c\u5217\u8868", notes="\u5e73\u53f0udc")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT_PAGE, operationDescription="\u5206\u9875\u67e5\u8be2UDC\u503c")
    public ApiResult<PagingVO<SysPlatformUdcValueMngVO>> queryUdcValueList(@RequestBody @Valid QueryUdcValueParam param) {
        PagingVO<SysPlatformUdcValueMngVO> page = this.sysPlatformUdcMngService.getUdcValuePage(param);
        return ApiResult.ok(page);
    }

    @PostMapping(value={"/export"}, produces={"application/octet-stream"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e")
    @BusinessObjectOperation(operationType=OperationTypeEnum.EXPORT, operationDescription="\u5bfc\u51fa\u6570\u636e")
    public ApiResult<Boolean> export(HttpServletResponse response, @RequestBody QueryUdcValueParam queryVO) {
        try {
            this.exportExcelService.export((AbstractExportQueryParam)queryVO, response, param -> this.sysPlatformUdcMngService.getUdcValuePage((QueryUdcValueParam)param)).get();
            return null;
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5931\u8d25\uff1a", (Throwable)e);
            return ApiResult.fail((String)("\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage()));
        }
    }

    @Autowired
    public void setExportExcelService(ExportExcelService<QueryUdcValueParam, SysPlatformUdcValueMngVO, Serializable> exportExcelService) {
        this.exportExcelService = exportExcelService;
    }
}

