/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.platform.controller.api.extend;

import com.elitescloud.boot.log.common.BusinessObject;
import com.elitescloud.boot.log.common.BusinessObjectOperation;
import com.elitescloud.boot.log.common.OperationScopeEnum;
import com.elitescloud.boot.log.common.OperationStateEnum;
import com.elitescloud.boot.log.common.OperationTypeEnum;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaDetailRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.resp.AreaMngTreeRespVO;
import com.elitescloud.cloudt.platform.model.vo.extend.save.PlatformAreaSaveVO;
import com.elitescloud.cloudt.platform.service.SysPlatformAreaService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u884c\u653f\u533a\u57df\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/platform/mng/area"}, produces={"application/json"})
@Validated
@BusinessObject(businessType="SysPlatformArea:\u5e73\u53f0\u533a\u57df")
public class SysPlatformAreaController {
    private final SysPlatformAreaService sysPlatformAreaService;

    public SysPlatformAreaController(SysPlatformAreaService sysPlatformAreaService) {
        this.sysPlatformAreaService = sysPlatformAreaService;
    }

    @GetMapping(value={"/tree"})
    @ApiOperation(value="\u884c\u653f\u533a\u57df\u6811")
    @ApiOperationSupport(order=1)
    @ApiImplicitParam(name="tree", value="\u662f\u5426\u8fd4\u56de\u6811\u72b6\uff0c\u9ed8\u8ba4false", defaultValue="false")
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u884c\u653f\u533a\u57df\u6811")
    public ApiResult<List<AreaMngTreeRespVO>> tree(@RequestParam(name="tree", defaultValue="false") Boolean tree) {
        return this.sysPlatformAreaService.tree(tree);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58\u884c\u653f\u533a\u57df")
    @ApiOperationSupport(order=2)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SAVE, operationDescription="\u4fdd\u5b58\u884c\u653f\u533a\u57df", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> save(@RequestBody @Valid PlatformAreaSaveVO saveVO) {
        return this.sysPlatformAreaService.save(saveVO);
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u83b7\u53d6\u884c\u653f\u533a\u57df\u8be6\u60c5")
    @ApiOperationSupport(order=3)
    @ApiImplicitParam(name="id", value="\u533a\u57dfID", required=true)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u884c\u653f\u533a\u57df\u8be6\u60c5")
    public ApiResult<AreaDetailRespVO> get(@PathVariable(value="id") Long id) {
        return this.sysPlatformAreaService.get(id);
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u884c\u653f\u533a\u57df\u8be6\u60c5")
    @ApiOperationSupport(order=4)
    @ApiImplicitParam(name="id", value="\u533a\u57dfID", required=true)
    @BusinessObjectOperation(operationType=OperationTypeEnum.DELETE, operationDescription="\u5220\u9664\u884c\u653f\u533a\u57df", logEnabled=true, argsJsonEnabled=true, resultJsonEnabled=true)
    public ApiResult<Long> delete(@PathVariable(value="id") Long id) {
        return this.sysPlatformAreaService.delete(id);
    }

    @PutMapping(value={"/tree/rebuild"})
    @ApiOperation(value="\u3010\u8c03\u8bd5\u3011\u91cd\u6784\u884c\u653f\u533a\u57df\u6811")
    @ApiOperationSupport(order=5)
    @BusinessObjectOperation(operationType=OperationTypeEnum.SELECT, operationDescription="\u91cd\u6784\u884c\u653f\u533a\u57df\u6811", operationScopeEnum=OperationScopeEnum.PRIVATE_TEST, operationStateEnum=OperationStateEnum.TESTING)
    public ApiResult<Boolean> treeRebuild() {
        return this.sysPlatformAreaService.execReBuildTree();
    }
}

