package com.elitescloud.cloudt.comm.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.comm.consumer.dto.ComPaymentTermRpcDTO;
import com.elitescloud.cloudt.comm.consumer.param.ComPaymentTermRpcDtoParam;
import com.elitescloud.cloudt.comm.vo.param.ComPaymentTermQueryParamVO;
import com.elitescloud.cloudt.comm.vo.resp.ComPaymentTermRespVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author shihao.ma
 * 2020/7/2
 */
@FeignClient(name = Application.NAME, path = ComPaymentTermProviderService.URI)
@Validated
@Unicom(domain = InvokeDomain.SYSTEM)
public interface ComPaymentTermProviderService {
    String URI = Application.URI_PREFIX + "/paymentTerm";

    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    @PostMapping(value = "/search")
    PagingVO<ComPaymentTermRespVO> search(@RequestBody ComPaymentTermQueryParamVO queryParam);

    /**
     * 根据关键字段，返回对应的vo
     *
     * @param code code
     * @return 对象
     */
    @GetMapping(value = "/getCodeOne")
    ComPaymentTermRespVO getCodeOne(@RequestParam(value = "code") @NotBlank(message = "编码为空") String code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param id ID
     * @return 对象
     */
    @GetMapping(value = "/getIdOne")
    ComPaymentTermRespVO getIdOne(@RequestParam(value = "id") @NotBlank(message = "id为空") Long id);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    @PostMapping(value = "/getIdOne")
    List<ComPaymentTermRespVO> findIdBatch(@RequestBody List<Long> idList);

    @GetMapping(value = "/list")
    List<ComPaymentTermRespVO> list();

    @PostMapping(value = "/findCodeBatch")
    List<ComPaymentTermRespVO> findCodeBatch(@RequestBody List<String> paymentTermCodes);

    /**
     * 获取支付条款信息列表，该接口一般应用与如下场景
     * 1. 第三方通过code获取一些基本信息，用于后端组装数据
     * 2. 检查数据是否存在，存在则会返回数据，不存在则不会返回数据
     * <p>
     * 如果传入的查询参数均为空，则不返回任何数据，防止获取全部数据
     * <p>
     * 注意接口返回数据没有上限控制，请合理使用，保证效能
     * 该接口在服务端配置 timeout 时间为 5s
     * 如果遇到 timeout 问题，请和开发协调沟通进行优化
     *
     * @param param dto 查询条件，每个条件使用 and 关联
     * @return dto
     */
    @PostMapping(value = "/findPaymentTermRpcDtoByParam")
    List<ComPaymentTermRpcDTO> findPaymentTermRpcDtoByParam(@RequestBody ComPaymentTermRpcDtoParam param);
}
