package com.elitescloud.cloudt.constant;

import com.elitescloud.cloudt.common.base.common.SafeEnum;

/**
 * 组织节点类型.
 *
 * @author Kaiser（wang shao）
 * 2022/9/30
 */
public final class OrgTreeNodeType extends SafeEnum<OrgTreeNodeType> {
    private static final long serialVersionUID = -5383074354674360191L;

    public static final OrgTreeNodeType ORG = new OrgTreeNodeType("ORG", "组织");
    public static final OrgTreeNodeType EMPLOYEE = new OrgTreeNodeType("EMPLOYEE", "员工");

    public OrgTreeNodeType() {
    }

    public OrgTreeNodeType(String value) {
        super(value);
    }

    public OrgTreeNodeType(String value, String description) {
        super(value, description);
    }
}
