package com.elitescloud.cloudt.system.dto.req;

import com.elitescloud.cloudt.common.base.vo.AreaVO;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 员工保存.
 *
 * @author Kaiser（wang shao）
 * @date 2/22/2023
 */
@Data
public class EmployeeUpsertDTO implements Serializable {
    private static final long serialVersionUID = 6471453453769471691L;

    /**
     * 员工ID
     */
    private Long id;

    /**
     * 员工编号
     * <p>
     * 新增时，如果为空将自动生成
     */
    private String code;

    /**
     * 是否在职
     */
    private Boolean served;

    /**
     * 照片
     */
    private String photo;

    /**
     * 是否启用，默认是
     */
    private Boolean enabled;

    /**
     * 员工类型
     * <p>
     * {@link com.elitescloud.cloudt.system.constant.EmployeeType}
     */
    private String type;

    /**
     * 所在组织ID
     */
    private List<Long> orgIdList;

    /**
     * 所在组织
     * <p></p>
     * 与{@link #orgIdList}至少有一个不为空
     */
    private List<EmployeeOrg> orgList;

    /**
     * 入职时间
     */
    private LocalDateTime joinTime;

//    以下是账号信息

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 性别
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     */
    private String gender;

    /**
     * 账号ID
     */
    private Long userId;

    /**
     * 登录账号
     * <p>
     * 新增时，如果为空将自动生成
     */
    private String username;

    /**
     * 登录密码
     */
    private String password;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 办公电话、手机号
     */
    private String phone;

    /**
     * 生日
     */
    private LocalDate birthDate;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 所在地
     */
    private AreaVO areaVO;

    /**
     * 地址
     */
    private String address;

    @Data
    public static class EmployeeOrg implements Serializable {
        private static final long serialVersionUID = -7057452386964797575L;

        /**
         * 组织ID
         */
        private Long orgId;

        /**
         * 上级领导ID
         */
        private Long leaderUserId;
    }
}
