package com.elitescloud.cloudt.system.dto.req;

import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 汇率查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 3/15/2023
 */
@Data
@Accessors(chain = true)
public class SysCurrencyRateQueryDTO implements Serializable {
    private static final long serialVersionUID = -446943291933114948L;

    /**
     * 源货币
     */
    @NotBlank(message = "从货币不能为空")
    private String fromCurr;

    /**
     * 至货币
     */
    @NotBlank(message = "至货币不能为空")
    private String toCurr;

    /**
     * 有效时间
     */
    private LocalDateTime validDate;

    /**
     * 有效时间-起始时间
     */
    private LocalDateTime validFromS;

    /**
     * 有效时间-截止时间
     */
    private LocalDateTime validFromE;

    /**
     * 失效时间-起始时间
     */
    private LocalDateTime validToS;

    /**
     * 失效时间-截止时间
     */
    private LocalDateTime validToE;
}
