package com.elitescloud.cloudt.system.dto.resp;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 员工分页查询返回结果.
 *
 * @author Kaiser（wang shao）
 * @date 2/27/2023
 */
@Data
public class EmployeePageRespDTO implements Serializable {
    private static final long serialVersionUID = -867544757883652835L;

    /**
     * 员工ID
     */
    private Long id;

    /**
     * 员工编码
     */
    private String code;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 登录号
     */
    private String username;

    /**
     * 姓名
     */
    private String fullName;

    /**
     * 性别
     * <p>
     * {@link com.elitescloud.cloudt.common.constant.Gender}
     * </p>
     */
    private String gender;

    /**
     * 性别
     */
    private String genderName;

    /**
     * 员工类型
     */
    private String type;

    /**
     * 员工类型
     */
    private String typeName;

    /**
     * 职务
     */
    private String duty;

    /**
     * 是否在职
     */
    private Boolean served;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 电话
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 下属数量
     */
    private Integer underlingNum;

    /**
     * 组织名称
     */
    private List<String> orgNames;

    /**
     * 是否有下级员工
     *
     * @return 是否有下级员工
     */
    public Boolean getHasUnderling() {
        return underlingNum != null && underlingNum > 0;
    }
}
