package com.elitescloud.cloudt.system.dto.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 导入结果.
 *
 * @author Kaiser（wang shao）
 * @date 2021-05-11
 */
@Data
@ApiModel(description = "导入结果")
@Builder
public class ImportResultRespVO implements Serializable {
    private static final long serialVersionUID = -2819268049473549541L;

    /**
     * 是否是同步导入
     */
    @ApiModelProperty(value = "是否是同步导入")
    private Boolean sync;

    /**
     * 同步导入结果
     */
    @ApiModelProperty(value = "同步导入结果")
    private SyncResult syncResult;

    /**
     * 异步导入结果
     */
    @ApiModelProperty(value = "异步导入结果")
    private AsyncResult asyncResult;

    /**
     * 同步导入结果
     */
    @Data
    @ApiModel(value = "Fsm_ImportResult_SyncResult", description = "同步导入结果")
    @Builder
    public static class SyncResult implements Serializable {

        private static final long serialVersionUID = 5467202772116021540L;

        /**
         * 导入总数
         */
        @ApiModelProperty(value = "导入总数")
        private Integer total;

        /**
         * 导入成功数量
         */
        @ApiModelProperty(value = "导入成功数量")
        private Integer numSuccess;

        /**
         * 导入失败记录
         */
        @ApiModelProperty(value = "导入失败记录")
        private List<String> failRecords;
    }

    /**
     * 异步导入结果
     */
    @Data
    @ApiModel(value = "Fsm_ImportResult_AsyncResult", description = "异步导入结果")
    @Builder
    public static class AsyncResult implements Serializable {

        private static final long serialVersionUID = -8128558468641849223L;

        /**
         * 导入记录标识
         */
        @ApiModelProperty(value = "导入记录标识")
        private Long importId;
    }
}
