package com.elitescloud.cloudt.system.param;

import lombok.Data;

import java.io.Serializable;
import java.util.Set;

/**
 * 组织查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2/23/2023
 */
@Data
public class SysOrgQueryDTO implements Serializable {
    private static final long serialVersionUID = -4850314311940497418L;

    /**
     * 组织ID
     */
    private Set<Long> ids;

    /**
     * 组织编码
     */
    private Set<String> codes;

    /**
     * 上级组织编码
     */
    private String parentCode;

    /**
     * 是否行政组织
     */
    private Boolean executive;

    /**
     * 组织名称
     */
    private String name;

    /**
     * 组织类型
     * <p></p>
     * {@link com.elitescloud.cloudt.system.constant.OrgType}
     */
    private String type;

    /**
     * 是否实体
     */
    private Boolean entity;

    /**
     * 是否启用
     */
    private Boolean enabled;

    /**
     * 所属公司ID（系统域的）
     */
    private Long ouId;

    /**
     * 所属组织的ID
     * <p>
     * 该组织下的所有子孙组织（包含自己）
     */
    private Long orgIdBelong;
}
