package com.elitescloud.cloudt.system.provider.extend;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysImportRateDTO;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.dto.req.RecordResultSaveDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Map;

/**
 * 导入导出模板管理接口.
 *
 * @author Kaiser（wang shao）
 * @date 2/17/2023
 */
@FeignClient(name = Application.NAME, path = SysTmplApiRpcService.URI)
@Validated
@Unicom(domain = InvokeDomain.SYSTEM)
public interface SysTmplApiRpcService {
    String URI = Application.URI_PREFIX + "/tmpl";

    /**
     * 根据模板编号获取模板信息
     *
     * @param code 模板编号
     * @return 模板信息
     */
    @GetMapping(value = "/getByCode")
    ApiResult<SysTmplDTO> getByCode(@RequestParam(name = "code") @NotBlank(message = "模板编码为空") String code);

    /**
     * 根据模板编号获取模板文件的编号
     *
     * @param code 模板编号
     * @return 模板信息
     */
    @GetMapping(value = "/getFileCodeByCode")
    ApiResult<String> getFileCodeByCode(@RequestParam(name = "code") @NotBlank(message = "模板编码为空") String code);

    /**
     * 保存导入导出记录
     *
     * @param code           模板编号
     * @param recordFileCode 导入导出记录的文件编码
     * @param queryParam     导出时的请求参数
     * @return 记录ID
     */
    @PostMapping(value = "/saveRecord")
    ApiResult<Long> saveRecord(@RequestParam(name = "code") @NotBlank(message = "模板编码为空") String code,
                               @RequestParam(name = "recordFileCode", required = false) String recordFileCode,
                               @RequestBody Map<String, Object> queryParam);

    /**
     * 更新总数
     *
     * @param recordId 记录标识
     * @param numTotal 总数
     * @return 记录标识
     */
    @PatchMapping(value = "/record/updateNumTotal")
    ApiResult<Long> updateNumTotal(@RequestParam(name = "recordId") @NotNull(message = "记录标识为空") Long recordId,
                                   @RequestParam(name = "numTotal") @NotNull(message = "总数为空") Long numTotal);

    /**
     * 更新结果
     *
     * @param resultDTO 结果
     * @return 记录标识
     */
    @PutMapping(value = "/record/updateResult")
    ApiResult<Long> updateResult(@RequestBody RecordResultSaveDTO resultDTO);

    /**
     * 获取导入进度
     *
     * @param recordId 记录标识
     * @return 导入进度
     */
    @GetMapping(value = "/record/getRate")
    ApiResult<SysImportRateDTO> getImportRate(@RequestParam(name = "recordId") @NotNull(message = "记录标识为空") Long recordId);

    /**
     * 获取记录的文件标识
     *
     * @param recordId 记录标识
     * @return 文件标识
     */
    @GetMapping(value = "/record/getFileCode")
    ApiResult<String> getRecordFileCode(@RequestParam(name = "recordId") @NotNull(message = "记录标识为空") Long recordId);

    /**
     * 获取未导入结束的记录ID
     *
     * @return 记录ID
     */
    @GetMapping(value = "/record/getUnfinished")
    ApiResult<List<Long>> queryUnFinished();

    /**
     * 保存导出文件
     *
     * @param recordId 记录ID
     * @param fileCode 文件标识
     * @param order    顺序
     * @return 结果
     */
    @PatchMapping(value = "/record/saveFile")
    ApiResult<Long> saveExportFile(@RequestParam(name = "recordId") @NotNull(message = "记录标识为空") Long recordId,
                                   @RequestParam(name = "fileCode") @NotNull(message = "文件标识为空") String fileCode,
                                   @RequestParam(name = "order") @NotNull(message = "顺序为空") Integer order);
}
