package com.elitescloud.cloudt.system.provider.org;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.OrgUpsertDTO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 组织服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2/23/2023
 */
@FeignClient(name = Application.NAME, path = OrgRpcService.URI)
@Validated
@Unicom(domain = InvokeDomain.SYSTEM)
public interface OrgRpcService {
    String URI = Application.URI_PREFIX + "/org";

    /**
     * 保存组织
     * <p>
     * 如果id不为空，则是修改
     *
     * @param upsertDTO 组织信息
     * @return 组织ID
     */
    @PostMapping(value = "/upsert")
    ApiResult<Long> upsert(@RequestBody @Valid OrgUpsertDTO upsertDTO);

    /**
     * 修改启用状态
     *
     * @param id      组织ID
     * @param enabled 启用状态
     * @return 组织ID
     */
    @PatchMapping(value = "/updateEnabled")
    ApiResult<Long> updateEnabled(@NotNull(message = "组织ID为空") @RequestParam("id") Long id,
                                  @NotNull(message = "启用状态为空") @RequestParam("enabled") Boolean enabled);

    /**
     * 删除组织
     * <p>
     * 如果下面有子组织，则不可直接删除
     *
     * @param id 组织ID
     * @return 组织ID
     */
    @DeleteMapping(value = "/delete")
    ApiResult<Long> delete(@NotNull(message = "组织ID为空") @RequestParam("id") Long id);

    /**
     * 根据ID获取组织信息
     *
     * @param id 组织ID
     * @return 组织信息
     */
    @GetMapping(value = "/getById")
    ApiResult<SysOrgBasicDTO> getById(@NotNull(message = "组织ID为空") @RequestParam("id") Long id);

    /**
     * 根据编码获取组织信息
     *
     * @param code 组织编码
     * @return 组织信息
     */
    @GetMapping(value = "/getByCode")
    ApiResult<SysOrgBasicDTO> getByCode(@NotBlank(message = "组织编码为空") @RequestParam("code") String code);

    /**
     * 查询组织列表
     *
     * @param queryDTO 查询参数
     * @return 组织列表
     */
    @PostMapping(value = "/queryList")
    ApiResult<List<SysOrgBasicDTO>> queryList(@RequestBody SysOrgQueryDTO queryDTO);
}
