package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.system.param.SysSettingQParam;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.vo.SysSettingVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * @author mir
 */
@FeignClient(name = Application.NAME, path = SysSettingService.URI)
@Validated
@Unicom(domain = InvokeDomain.SYSTEM)
public interface SysSettingService {
    String URI = Application.URI_PREFIX + "/setting";

    /**
     * 根据查询条件对象，将找到的设置记录分页返回
     *
     * @param param 查询条件对象
     * @return 分页后的设置记录集合
     */
    @PostMapping(value = "/search")
    PagingVO<SysSettingVO> search(@RequestBody SysSettingQParam param);

    /**
     * 列出所有的配置记录
     *
     * @return 所有配置记录的集合
     */
    @GetMapping(value = "/all")
    List<SysSettingVO> all();

    /**
     * 通过记录ID，查找对应的设置记录
     *
     * @param id 记录ID
     * @return 找到的设置记录，没找到返回null
     */
    @GetMapping(value = "/oneById")
    SysSettingVO oneById(@RequestParam(value = "id") @NotNull(message = "ID为空") Long id);

    /**
     * 通过设置编码，查找对应的设置记录
     *
     * @param no 设置编码
     * @return 找到的设置记录，没找到返回null
     */
    @GetMapping(value = "/oneByNo")
    SysSettingVO oneByNo(@RequestParam(value = "no") @NotNull(message = "编号为空") String no);

    /**
     * 将提交的设置对象，在数据库中创建新的纪录
     *
     * @param sysSetting 待创建的设置对象
     * @return 新建设置记录的记录ＩＤ
     */
    @PostMapping(value = "/create")
    Long create(@RequestBody SysSettingVO sysSetting);

    /**
     * 将提交的设置对象，更新数据库记录
     *
     * @param sysSettingVO 待更新的设置对象
     */
    @PostMapping(value = "/update")
    void update(@RequestBody SysSettingVO sysSettingVO);

    /**
     * 将提供的记录ID对应的记录删除
     *
     * @param ids
     */
    @DeleteMapping(value = "/removeByIds")
    void removeByIds(@RequestBody List<Long> ids);

    /**
     * 将提供的编码对应的记录删除
     *
     * @param nos 设置编码列表
     */
    @DeleteMapping(value = "/removeByNos")
    void removeByNos(@RequestBody List<String> nos);
}
