package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.param.*;
import com.elitescloud.cloudt.system.vo.SysPermissionVO;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * 系统用户操作逻辑服务类
 *
 * @author Michael Li
 * 2020/6/16
 * @deprecated 请使用SysUserRpcService
 */
@Deprecated(forRemoval = true, since = "3.6")
@FeignClient(name = Application.NAME, path = SysUserService.URI)
@Validated
@Unicom(domain = InvokeDomain.SYSTEM)
public interface SysUserService {
    String URI = Application.URI_PREFIX + "/deprecated" + "/user";

    /**
     * 根据查询条件检索用户信息
     *
     * @param param 查询条件对象
     * @return 用户信息集合
     */
    @PostMapping(value = "/search")
    PagingVO<SysUserVO> search(@RequestBody SysUserQueryParam param);

    /**
     * @param id
     * @return
     */
    @GetMapping(value = "/getById")
    SysUserDTO getById(@RequestParam(value = "id") @NotNull(message = "ID为空") Long id);

    @PostMapping(value = "/getByIds")
    List<SysUserVO> getByIds(@RequestBody List<Long> ids);

    /**
     * 根据用户账号，返回脱敏的用户信息，VO
     *
     * @param username 用户账号
     * @return 脱敏的用户信息
     */
    @GetMapping(value = "/getUserByUsername")
    SysUserDTO getUserByUsername(@RequestParam(value = "username") @NotNull(message = "用户账号为空") String username);

    /**
     * 创建新用户
     *
     * @param user 用户账号信息
     * @return 新用户账号ID
     */
    @PostMapping(value = "/create")
    Long create(@RequestBody SysUserNewParam user);

    @PostMapping(value = "/createWithPwd")
    Long create(@RequestBody SysUserNewParam user,
                @RequestParam(value = "password") @NotNull(message = "用户密码为空") String password);

    @PostMapping(value = "/update")
    void update(@RequestBody SysUserUpdateParam user);

    @GetMapping(value = "/switchUserStatus")
    Boolean switchUserStatus(@RequestParam(value = "id") @NotNull(message = "用户ID为空") Long id);

    /**
     * 用户 批量启用/禁用
     *
     * @param param 参数
     */
    @PostMapping(value = "/batchSwitchUserStatus")
    void batchSwitchUserStatus(@RequestBody SysUserBatchSwitchParam param);

    @GetMapping(value = "/listRolesByUsername")
    Set<SysRoleVO> listRolesByUsername(@RequestParam(value = "username") @NotNull(message = "用户账号为空") String username);

    @GetMapping(value = "/current")
    SysUserDTO current();

    @GetMapping(value = "/currentMenu")
    List<SysPermissionVO> currentMenu();

    @GetMapping(value = "/currentActions")
    Set<SysPermissionVO> currentActions();

    @GetMapping(value = "/currentMenuActions")
    Set<SysPermissionVO> currentMenuActions(@RequestParam(value = "menuId") @NotNull(message = "菜单ID为空") Long menuId);

    @DeleteMapping(value = "/deleteBatch")
    void deleteBatch(@RequestBody List<Long> idList);

    @PostMapping(value = "/updatePassword")
    void updatePassword(@RequestBody SysPasswordUpdate update);
}
