package com.elitescloud.cloudt.revision.dto;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author Chris
 * @date 2021-03-26
 */
@Data
@ApiModel("币种DTO信息")
public class ComCurrRpcDTO implements Serializable {

    private static final long serialVersionUID = -2643993434727638980L;

    @JsonSerialize(using = ToStringSerializer.class)
    @ApiModelProperty("记录唯一ID")
    private Long id;

    @ApiModelProperty("币种编号")
    private String currCode;

    @ApiModelProperty("币种名称")
    private String currName;
}
