package com.elitescloud.cloudt.revision.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.revision.vo.param.ComCommonTaxRateQueryParamVO;
import com.elitescloud.cloudt.revision.vo.param.ComTaxRateQueryParamDTO;
import com.elitescloud.cloudt.revision.vo.param.ComTaxRateQueryParamVO;
import com.elitescloud.cloudt.revision.vo.resp.ComCommonTaxRateRespVO;
import com.elitescloud.cloudt.revision.vo.resp.ComTaxRateRespVO;
import com.elitescloud.cloudt.revision.vo.resp.ComTaxRateVO;

import java.util.List;
import java.util.Set;

/**
 * <p>
 * 税率
 * </p>
 *
 * @author zhenghaiyang
 * @date 2020/7/2
 */
@Deprecated(forRemoval = true, since = "0.3.0")
public interface ComTaxRateProviderService {

    List<ComTaxRateVO> findBytaxRateNoList(List<String> strings);

    /**
     * 查找税率共通方法
     *
     * @param param 单个入参
     * @return 返回 单个税率
     * @author 常昊阳 haoyang.chang@elitesland.com
     */
    ComCommonTaxRateRespVO getRatioOrNull(ComCommonTaxRateQueryParamVO param);

    /**
     * 根据税率编号及索引查询唯一税率 liuqi 2020.10.23
     *
     * @param taxRateNo    税率编号
     * @param taxRateIndex 税率索引
     * @return 税率
     */
    ComTaxRateVO findByTaxRateNoAndIndexOrNull(String taxRateNo, String taxRateIndex);

    /**
     * @param taxRateNo, taxRateIndex
     * @return java.util.Optional<com.elitesland.basic.vo.ComTaxRateVO>
     * @Author Kevin.yuan
     * @Data 2020/12/10 10:10
     **/
    List<ComTaxRateRespVO> findBytaxRateNoInAndIndexIn(Set<String> taxRateNo, Set<String> taxRateIndex);

    PagingVO<ComTaxRateRespVO> searchAll(ComTaxRateQueryParamVO param);

    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    PagingVO<ComTaxRateRespVO> search(ComTaxRateQueryParamVO queryParam);

    /**
     * 根据关键字段，返回对应的vo
     *
     * @param Code code
     * @return 对象
     */
    ComTaxRateRespVO getCodeOne(String Code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param Id ID
     * @return 对象
     */
    ComTaxRateRespVO getIdOne(Long Id);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    List<ComTaxRateRespVO> findIdBatch(List<Long> idList);

    /**
     * 查询税率
     *
     * @param queryParamDTO 查询参数
     * @return 税率列表
     */
    List<ComTaxRateRespVO> query(ComTaxRateQueryParamDTO queryParamDTO);
}
