package com.elitescloud.cloudt.system.constant;


import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 消息类型
 * **/
public enum MsgSendStateEnum {
    OK("SYS", "MsgSendState", "OK", "成功",1),
    //Low-Code Development Platform
    SENDING("SYS", "MsgSendState", "SENDING", "进行中",2),
    FAILED("SYS", "MsgSendState", "FAILED", "失败",3),
    ;


    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    MsgSendStateEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
    public static List<SysUdcVO> getSysUdcVOList() {
        ArrayList<SysUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }
}
