package com.elitescloud.cloudt.system.constant;


import com.elitescloud.cloudt.system.vo.SysUdcVO;

import java.util.ArrayList;
import java.util.List;

/**
 * 消息类型枚举
 * **/
public enum MsgSendTypeEnum {
    SYS_INTERIOR("SYS", "MsgSendType", "SYS_INTERIOR", "系统站内",1),
    EMAIL("SYS", "MsgSendType", "EMAIL", "邮件",2),
    //Low-Code Development Platform
    MOBILE_SMS("SYS", "MsgSendType", "MOBILE_SMS", "短信",3),
    MINI_PROGRAM("SYS", "MsgSendType", "MINI_PROGRAM", "小程序",4),

    OFFICIAL_ACCOUNT("SYS", "MsgSendType", "OFFICIAL_ACCOUNT", "公众号",5),

    APP("SYS", "MsgSendType", "APP", "原生APP",6),
    ;


    private final String domainCode;
    private final String udcCode;
    private final String udcName;
    private final String description;
    private final int sortNo;

    MsgSendTypeEnum(String domainCode, String udcCode, String udcName, String description, int sortNo) {
        this.domainCode = domainCode;
        this.sortNo = sortNo;
        this.udcCode = udcCode;
        this.udcName = udcName;
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    public SysUdcVO getUdcVO() {
        SysUdcVO sysUdcVO = new SysUdcVO();
        sysUdcVO.setDomainCode(this.domainCode);
        sysUdcVO.setUdcCode(this.udcCode);
        sysUdcVO.setUdcName(this.udcName);
        sysUdcVO.setUdcVal(this.name());
        sysUdcVO.setValDesc(this.description);
        sysUdcVO.setValSortNo(this.sortNo);
        sysUdcVO.setId((long) this.sortNo);
        return sysUdcVO;
    }
    public static List<SysUdcVO> getSysUdcVOList() {
        ArrayList<SysUdcVO> sysUdcVOList = new ArrayList<>();
        for (var ele : values()) {
            sysUdcVOList.add(ele.getUdcVO());
        }
        return sysUdcVOList;
    }
}
