package com.elitescloud.cloudt.system.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * @author : chen.niu
 * @description :
 * : 2023/1/31 23:18
 */
@Data
public class SysDpcRoleApiFieldsDTO implements java.io.Serializable {

    private static final long serialVersionUID = -5228800510752566741L;
    @ApiModelProperty("角色id")
    Long roleId;

    @ApiModelProperty("应用id")
    Long appId;

    @ApiModelProperty("菜单编码-因有自定义菜单，采用编码")
    String menuCode;

    @ApiModelProperty("APIid")
    Long apiId;

    //    @ApiModelProperty("列字段")
//    String columnFields;
//
//    @ApiModelProperty("列字段是否有权限")
//    Boolean columnFieldsExists;
    @ApiModelProperty(name = "字段名称", notes = "")
    private String fieldName;

    @ApiModelProperty(name = "字段描述", notes = "")
    private String fieldRemark;

    @ApiModelProperty(name = "api可见", notes = "")
    private Boolean fieldApiVisible;

    @ApiModelProperty(name = "表单可见", notes = "")
    private Boolean fieldFormVisible;

    @ApiModelProperty(name = "表单可编辑", notes = "")
    private Boolean fieldFormUpdate;

    /***角色信息**/
    @ApiModelProperty("角色编码")
    private String roleCode;

    @ApiModelProperty("角色名称")
    private String roleName;

    @ApiModelProperty(value = "角色类型")
    private String roleType;

    @ApiModelProperty(value = "类型标识")
    private String roleTypeId;

    /**
     * 应用信息
     */
    @ApiModelProperty("应用编码")
    String appCode;

    @ApiModelProperty("应用名称")
    String appName;

    @ApiModelProperty("应用类型")
    String appType;

    @ApiModelProperty("描述")
    String appDescribe;

    /**
     * api接口信息
     ***/
    @ApiModelProperty("权限路径")
    String apiPermissionPath;

    @ApiModelProperty("权限名称")
    String apiPermissionName;

    @ApiModelProperty("权限编码")
    String apiPermissionCode;

    @ApiModelProperty("请求类型")
    String apiPermissionRequestType;

    @ApiModelProperty("描述")
    String apiPermissionDescribe;


    /**
     * 菜单信息
     **/
    @ApiModelProperty("菜单归属应用")
    String menusAppCode;

    @ApiModelProperty("菜单名称")
    String menusName;

    @ApiModelProperty("菜单类型 业务,系统")
    String menusType;

    @ApiModelProperty("节点类型 菜单,按钮")
    String menusNodeType;

    @ApiModelProperty("菜单编码")
    String menusCode;

    @ApiModelProperty("上级菜单编码")
    String menusParentCode;

    @ApiModelProperty("菜单路由")
    String menusRoute;

    @ApiModelProperty("描述")
    String menusDescribe;


}
