package com.elitescloud.cloudt.system.dto.req;

import com.elitescloud.boot.common.param.AbstractOrderQueryParam;
import lombok.Data;

import java.util.Set;

/**
 * 员工分页查询参数.
 *
 * @author Kaiser（wang shao）
 * @date 2/27/2023
 */
@Data
public class EmployeePageQueryDTO extends AbstractOrderQueryParam {
    private static final long serialVersionUID = 1211735072794036689L;

    /**
     * 员工ID
     */
    private Set<Long> ids;

    /**
     * 员工编号
     */
    private Set<String> codes;

    /**
     * 所属组织ID
     */
    private Long orgId;

    /**
     * 员工类型
     * <p>
     * {@link com.elitescloud.cloudt.system.constant.EmployeeType}
     * </p>
     */
    private String type;

    /**
     * 启用状态
     */
    private Boolean enabled;

    /**
     * 登录账号
     */
    private String username;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 姓名-姓氏
     */
    private String lastName;

    /**
     * 姓名-名字
     */
    private String firstName;

    /**
     * 是否查询下属员工数量，默认是
     */
    private Boolean withUnderlingNum = true;

    /**
     * 是否没有上级
     * true：查询没有领导的员工；false：查询有领导的员工；null：都查询，不过滤
     */
    private Boolean withoutLeader;
}
