package com.elitescloud.cloudt.system.dto.req.msg.template;

import com.elitescloud.cloudt.system.constant.MsgSendTypeEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * @author : chen.niu
 * @description : 发送人对象
 * @date : 2023/5/25 11:44
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TemplateAssignRecipientUserDTO implements Serializable {

    private static final long serialVersionUID = 7374496773956002475L;

    @ApiModelProperty("用户id")
    private Long userId;
    @ApiModelProperty("用户名称")
    private String userName;
    @ApiModelProperty("用户编码-账号NAME")
    private String userCode;
    @ApiModelProperty("用户备用")
    private String userStandby;

    @ApiModelProperty("接收人的发送类型参数：如邮件-邮箱，短信-手机号")
    Map<MsgSendTypeEnum,TemplateAssignRecipientUserAccountDTO> recipientUserAccountDtoMap;

}
