package com.elitescloud.cloudt.system.dto.req.msg.template;

import com.elitescloud.cloudt.system.dto.req.msg.MsgSendEmployeeUserDTO;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author : chen.niu
 * @description :
 * @date : 2023/5/25 13:11
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TemplateAssignSendParamDTO implements Serializable {
    private static final long serialVersionUID = -8175456512373022929L;

    /**
     * 模板编码
     */
    @ApiModelProperty("模板编码")
    private String templateCode;

    /**
     * 标题的模板参数替换 如：${name} key=name，value=名称
     */
    @ApiModelProperty("标题的模板参数替换 如：${name} key=name，value=名称")
    private Map<String,String> titleReplaceMap;

    /**
     * 内容的模板参数替换 如：${name} key=name，value=名称
     */
    @ApiModelProperty("内容的模板参数替换 如：${name} key=name，value=名称")
    private Map<String,String> contentReplaceMap;

    /**
     * 发送人对象，为空则取当前操作人
     */
    @ApiModelProperty("发送人对象，为空则取当前操作人")
    private MsgSendEmployeeUserDTO sendUser;

    /**
     * 接收人对象集合
     */
    @ApiModelProperty("接收人对象集合")
    private List<TemplateAssignRecipientUserDTO> recipientUserList;

    /**
     * title占位替换配置-可空
     * @deprecated 请使用 {@link #titleReplaceMap}
     */
    @ApiModelProperty("title占位替换配置-可空")
    private List<TemplateTxtReplaceDTO> msgTemplateTitleReplaceDTOS;

    /**
     * content内容占位符替换配置-可空
     * @deprecated 请使用 {@link #contentReplaceMap}
     */
    @ApiModelProperty("content内容占位符替换配置-可空")
    private List<TemplateTxtReplaceDTO> msgTemplateContentReplaceDTOS;

    /**
     * 业务自定义参数
     */
    @ApiModelProperty("消息关联参数，详情页存储")
    private Map<String,String> mesJoinParamMap;
}
