package com.elitescloud.cloudt.system.provider;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.param.*;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcSaveParam;
import com.elitescloud.cloudt.system.vo.SysPermissionVO;
import com.elitescloud.cloudt.system.vo.SysRoleVO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitescloud.cloudt.system.vo.SysUserVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * @author Chris
 * 2021-08-27
 * @deprecated 请使用 {@link com.elitescloud.cloudt.system.provider.org.UserRpcService}
 */
@Validated
@Unicom(domain = InvokeDomain.SYSTEM, path = SysUserRpcService.URI)
@Deprecated(forRemoval = true, since = "3.2.0")
public interface SysUserRpcService {
    String URI = Application.URI_PREFIX + "/user";

    /**
     * 根据查询条件检索用户信息
     *
     * @param param 查询条件对象
     * @return 用户信息集合
     */
    @PostMapping(value = "/search")
    PagingVO<SysUserVO> search(@RequestBody SysUserQueryParam param);

    /**
     * @param id
     * @return
     */
    @GetMapping(value = "/getById")
    SysUserDTO getById(@RequestParam(value = "id") @NotNull(message = "ID为空") Long id);

    @PostMapping(value = "/getByIds")
    List<SysUserVO> getByIds(@RequestBody List<Long> ids);

    /**
     * 创建新用户
     *
     * @param user 用户账号信息
     * @return 新用户账号ID
     */
    @PostMapping(value = "/create")
    Long create(@RequestBody SysUserNewParam user);

    @PostMapping(value = "/createWithPwd")
    Long create(@RequestBody SysUserNewParam user,
                @RequestParam(value = "password") @NotNull(message = "用户密码为空") String password);

    @PostMapping(value = "/update")
    void update(@RequestBody SysUserUpdateParam user);

    @GetMapping(value = "/switchUserStatus")
    Boolean switchUserStatus(@RequestParam(value = "id") @NotNull(message = "用户ID为空") Long id);

    /**
     * 用户 批量启用/禁用
     *
     * @param param 参数
     */
    @PostMapping(value = "/batchSwitchUserStatus")
    void batchSwitchUserStatus(@RequestBody SysUserBatchSwitchParam param);

    @GetMapping(value = "/listRolesByUsername")
    Set<SysRoleVO> listRolesByUsername(@RequestParam(value = "username") @NotNull(message = "用户账号为空") String username);

    @GetMapping(value = "/current")
    SysUserDTO current();

    @GetMapping(value = "/currentMenu")
    List<SysPermissionVO> currentMenu();

    @GetMapping(value = "/currentActions")
    Set<SysPermissionVO> currentActions();

    @GetMapping(value = "/currentMenuActions")
    Set<SysPermissionVO> currentMenuActions(@RequestParam(value = "menuId") @NotNull(message = "菜单ID为空") Long menuId);

    @DeleteMapping(value = "/deleteBatch")
    void deleteBatch(@RequestBody List<Long> idList);

    @PostMapping(value = "/updatePassword")
    void updatePassword(@RequestBody SysPasswordUpdate update);

    @PutMapping(value = "/updatePassword")
    void changePasswordNoSec(@RequestParam(value = "userId") @NotNull(message = "用户ID为空") Long userId,
                             @RequestParam(value = "pwd", required = false)  String pwd);

    /**
     * 更新用户绑定的微信id
     *
     * @param userName 用户登录号
     * @param openid   微信id
     * @return 用户登录号
     */
    @GetMapping(value = "/updateUserWechatOpenid")
    ApiResult<String> updateUserWechatOpenid(@RequestParam(value = "userName") @NotBlank(message = "登录号不能为空") String userName,
                                             @RequestParam(value = "openid", required = false) String openid);

    /**
     * 查询用户信息
     *
     * @param param 查询条件
     * @return dto
     */
    @PostMapping(value = "/findUserRpcDtoByParam")
    List<SysUserRpcDTO> findUserRpcDtoByParam(@RequestBody SysUserRpcDtoParam param);

    /**
     * 第三方，创建用户账号，创建的默认来源为 oth
     *
     * @param param 保存参数
     * @return 用户id
     */
    @PostMapping(value = "/sysUserAccountCreate")
    ApiResult<Object> sysUserAccountCreate(@RequestBody SysUserRpcSaveParam param);

    @PostMapping(value = "/sysUserCreate")
    ApiResult<Long>  sysUserCreate(@RequestBody SysUserNewParam user,
                                   @RequestParam(name = "password") @NotBlank(message = "密码为空") String password);

    /**
     * 根据用户名获取用户ID
     *
     * @param username 用户名
     * @return 用户ID
     */
    @GetMapping(value = "/getUserIdByUsername")
    ApiResult<Long> getUserIdByUsername(@RequestParam(name = "username") @NotBlank(message = "用户名为空") String username);

    /**
     * 根据用户账号查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param username 用户账号
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserByUsername")
    ApiResult<SysUserDTO> getUserByUsername(@RequestParam(name = "username") @NotBlank(message = "用户名为空") String username);

    /**
     * 根据用户手机号查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param mobile 手机号
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserByMobile")
    ApiResult<SysUserDTO> getUserByMobile(@RequestParam(name = "mobile") @NotBlank(message = "手机号为空") String mobile);

    /**
     * 根据用户邮箱查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param email 邮箱
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserByEmail")
    ApiResult<SysUserDTO> getUserByEmail(@RequestParam(name = "email") @NotBlank(message = "邮箱为空") String email);

    /**
     * 根据用户ID查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param userId 用户ID
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserById")
    ApiResult<SysUserDTO> getUserById(@RequestParam(name = "userId") @NotBlank(message = "用户ID为空") String userId);

    /**
     * 根据用户微信号查询用户详细信息
     * <p>
     * 用于登录
     *
     * @param wechatOpenid 用户微信号
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserByWechatOpenid")
    ApiResult<SysUserDTO> getUserByWechatOpenid(@RequestParam(name = "wechatOpenid") @NotBlank(message = "微信号为空") String wechatOpenid);

    /**
     * 账号为空
     *
     * @param account 账号
     * @return 用户详细信息
     */
    @GetMapping(value = "/getUserByAccount")
    ApiResult<SysUserDTO> getUserByAccount(@RequestParam(name = "account") @NotBlank(message = "账号为空") String account);

    @GetMapping(value = "/existsByUserName")
    Boolean existsByUserName(@RequestParam(name = "userName") @NotBlank(message = "用户名为空") String userName);

    @GetMapping(value = "/existsByUserMobile")
    Boolean existsByUserMobile(@RequestParam(name = "mobile") @NotBlank(message = "手机号为空") String mobile);
}
