package com.elitescloud.cloudt.system.provider;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;

import java.util.List;

/**
 * 租户RPC服务接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/24
 */
@Validated
@Unicom(domain = InvokeDomain.SYSTEM, path = TenantRpcProvider.URI)
public interface TenantRpcProvider {
    String URI = Application.URI_PREFIX + "/tenant";

    /**
     * 查询所有租户信息
     *
     * @return 租户信息
     */
    @GetMapping(value = "/allTenants")
    ApiResult<List<SysTenantDTO>> allTenants();
}
