package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author : chen
 *  角色应用api的数据权限远程调用接口
 * 2022-11-24 14:23
 */
@Validated
@Unicom(domain = InvokeDomain.SYSTEM, path = RoleAppApiDataPermissionRpcService.URI)
public interface RoleAppApiDataPermissionRpcService {
    String URI = Application.URI_PREFIX + "/role/app/api/data/permission";

    /**
     * 获取角色的数据权限信息
     * @return 角色ID的数据集合
     */
    @PostMapping(value = "/getRoleAppApiDataRulePermission")
    ApiResult<SysDprRoleApiRowColumnRuleDTO> getRoleAppApiDataRulePermission();

    /**
     * 获取角色的数据权限信息
     * @return 角色ID的数据集合
     */
    @GetMapping(value = "/getDataRulePermission")
    ApiResult<SysDprRoleApiRowColumnRuleDTO> getDataRulePermission();
}
