package com.elitescloud.cloudt.system.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateAssignSendParamDTO;
import com.elitescloud.cloudt.system.dto.req.msg.template.TemplateEmployeeSendParamDTO;
import com.elitescloud.cloudt.system.param.SysSendResultParam;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import java.util.List;

/**
 * @author : chen.niu
 * @description : 消息服务消息发送接口
 * @date : 2023/5/25 11:01
 */
@Validated
@Unicom(domain = InvokeDomain.SYSTEM, path = SysMsgTemplateSendRpcService.URI)
public interface SysMsgTemplateSendRpcService {
    String URI = Application.URI_PREFIX + "/msg/template/send";

    /**
     * 模板消息批量，员工参数发送接口（RPC接口
     * EmployeeSendParamDTO 模板消息员工对象
     *
     * @return 批记录ID
     */
    @PostMapping(value = "/templateEmployeeSend")
    ApiResult<String> msgTemplateEmployeeSend(@RequestBody @Valid TemplateEmployeeSendParamDTO param);

    /**
     * 模板消息批量，员工参数发送接口（RPC接口
     * EmployeeSendParamDTO 模板消息员工对象
     *
     * @return 成功失败
     */
    @PostMapping(value = "/templateEmployeeSend/batch")
    ApiResult<List<SysSendResultParam>> msgTemplateEmployeeSend(@RequestBody @Valid List<TemplateEmployeeSendParamDTO> paramList);

    /**
     * 模板消息批量，传递发送参数接口（RPC接口）
     *
     * @return 批记录ID
     */
    @PostMapping(value = "/templateMsgTypeParamSend")
    ApiResult<String> msgTemplateMsgTypeParamSend(@RequestBody @Valid TemplateAssignSendParamDTO param);

    /**
     * 模板消息批量，传递发送参数接口（RPC接口）
     *
     * @return 成功失败
     */
    @PostMapping(value = "/templateMsgTypeParamSend/batch")
    ApiResult<List<SysSendResultParam>> msgTemplateMsgTypeParamSend(@RequestBody @Valid List<TemplateAssignSendParamDTO> paramList);
}
