package com.elitescloud.cloudt.revision.service;

import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.revision.vo.param.ComCurrQueryParamVO;
import com.elitescloud.cloudt.revision.vo.resp.ComCurrRespVO;
import com.elitescloud.cloudt.revision.vo.resp.ComCurrVO;
import com.elitesland.cbpl.unicom.annotation.Unicom;
import com.elitesland.cbpl.unicom.domain.InvokeDomain;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author Chris
 * @date 2021-03-25
 */
@Deprecated(forRemoval = true, since = "0.3.0")
@Unicom(domain = InvokeDomain.SYSTEM, path = ComCurrProviderService.URI)
public interface ComCurrProviderService {

    String URI = Application.URI_PREFIX + "/deprecated" + "/curr/provider";

    /**
     * 获取全部币种信息
     *
     * @return 币种信息
     */
    @GetMapping(value = "/findAllVos")
    List<ComCurrVO> findAllVos();


    // ======================================= 分割线 =======================================


    /**
     * 根据货币code查询货币
     *
     * @param currList
     * @return 货币
     */
    @PostMapping(value = "/findByCodes")
    List<ComCurrRespVO> findByCodes(@RequestBody List<String> currList);

    /**
     * 货币下拉
     *
     * @return
     */
    @GetMapping(value = "/searchAll")
    List<ComCurrRespVO> searchAll();

    /**
     * 检索
     *
     * @param queryParam 分类查询、分页和排序对象
     * @return 分页结果集
     */
    @PostMapping(value = "/search")
    PagingVO<ComCurrRespVO> search(@RequestBody ComCurrQueryParamVO queryParam);

    /**
     * 根据关键字段，返回对应的vo
     *
     * @param Code code
     * @return 对象
     */
    @GetMapping(value = "/getCodeOne")
    ComCurrRespVO getCodeOne(@RequestParam("Code") String Code);

    /**
     * 根据关键字段，返回对应的
     *
     * @param Id ID
     * @return 对象
     */
    @GetMapping(value = "/getIdOne")
    ComCurrRespVO getIdOne(@RequestParam("id") Long Id);

    /**
     * 根据关键字段，返回对应的
     *
     * @param idList ID集合
     * @return 对象
     */
    @PostMapping(value = "/findIdBatch")
    List<ComCurrRespVO> findIdBatch(@RequestBody List<Long> idList);
}
